/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.navigator.ILinkHelper;

public class SessionLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        IWorkbenchPage page;
        IEditorPart editor;
        StructuredSelection returnSelection = null;
        IFile file = ResourceUtil.getFile((IEditorInput)anInput);
        if (file != null) {
            returnSelection = new StructuredSelection((Object)file);
        }
        if ((editor = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findEditor(anInput)) instanceof DialectEditor) {
            Collection<DSemanticDecorator> semanticDecorators = DialectUIManager.INSTANCE.getSelection((DialectEditor)editor);
            if (!semanticDecorators.isEmpty()) {
                ArrayList<EObject> elements = new ArrayList<EObject>();
                for (DSemanticDecorator currentDecorator : semanticDecorators) {
                    elements.add(currentDecorator.getTarget());
                }
                returnSelection = new StructuredSelection(elements);
            } else {
                Object editorRepresentation = this.getEditorRepresentation(anInput, editor);
                if (editorRepresentation != null) {
                    returnSelection = new StructuredSelection(editorRepresentation);
                }
            }
        }
        return returnSelection == null ? StructuredSelection.EMPTY : returnSelection;
    }

    private Object getEditorRepresentation(IEditorInput anInput, IEditorPart editor) {
        SessionEditorInput sessionInput;
        Session session;
        DRepresentation foundElement = null;
        if (anInput instanceof SessionEditorInput && (session = (sessionInput = (SessionEditorInput)anInput).getSession(false)) != null && session.isOpen() && editor instanceof DialectEditor) {
            foundElement = ((DialectEditor)editor).getRepresentation();
        }
        return foundElement;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        DialectEditor editor;
        IEditingSession uiSession;
        Session session;
        if (aPage == null || aSelection == null || aSelection.isEmpty()) {
            return;
        }
        DRepresentation selectedRepresentation = this.getSelectedRepresentation(aSelection.toList());
        IEditorPart activeEditor = aPage.getActiveEditor();
        if (activeEditor != null && selectedRepresentation != null && (session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)selectedRepresentation).getTarget())) != null && (uiSession = SessionUIManager.INSTANCE.getUISession(session)) != null && (editor = uiSession.getEditor(selectedRepresentation)) != null && editor.getSite() != null && aPage.equals(editor.getSite().getPage())) {
            activeEditor = editor;
            aPage.bringToTop((IWorkbenchPart)activeEditor);
        }
    }

    private DRepresentation getSelectedRepresentation(Collection<?> selection) {
        DRepresentation rep = null;
        Iterable selectedReps = Iterables.filter(selection, DRepresentation.class);
        if (selectedReps.iterator().hasNext()) {
            rep = (DRepresentation)selectedReps.iterator().next();
        } else {
            Iterable selectedItems = Iterables.filter(selection, RepresentationItemImpl.class);
            if (selectedItems.iterator().hasNext()) {
                rep = ((RepresentationItemImpl)selectedItems.iterator().next()).getRepresentation();
            }
        }
        return rep;
    }
}

