/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FilterCopy;
import org.eclipse.ui.internal.ide.dialogs.FilterEditDialog;
import org.eclipse.ui.internal.ide.dialogs.FilterTypeUtil;
import org.eclipse.ui.internal.ide.dialogs.ICustomFilterArgumentUI;

class DefaultCustomFilterArgumentUI
implements ICustomFilterArgumentUI {
    protected Shell shell;
    protected FilterCopy filter;
    protected Text arguments;
    protected Label argumentsLabel;
    protected Label description;
    protected ContentAssistCommandAdapter fContentAssistField;
    protected FilterEditDialog dialog;
    public static final String REGEX_FILTER_ID = "org.eclipse.core.resources.regexFilterMatcher";

    public DefaultCustomFilterArgumentUI(FilterEditDialog dialog, Shell parentShell, FilterCopy filter) {
        this.shell = parentShell;
        this.dialog = dialog;
        this.filter = filter;
    }

    @Override
    public Object getID() {
        return "";
    }

    @Override
    public void dispose() {
        Widget[] list = new Widget[]{this.arguments, this.argumentsLabel, this.description};
        int i = 0;
        while (i < list.length) {
            if (list[i] != null) {
                list[i].dispose();
            }
            ++i;
        }
        this.arguments = null;
        this.argumentsLabel = null;
        this.fContentAssistField = null;
        this.description = null;
    }

    @Override
    public void create(Composite argumentComposite, Font font) {
        this.shell = argumentComposite.getShell();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = this.dialog.getVerticalDLUsToPixel(7);
        argumentComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        argumentComposite.setLayoutData((Object)data);
        argumentComposite.setFont(font);
        if (this.filter.hasStringArguments()) {
            this.createArgumentsArea(font, argumentComposite);
        }
        this.createDescriptionArea(font, argumentComposite);
        if (this.fContentAssistField != null) {
            this.fContentAssistField.setEnabled(this.filter.getId().equals(REGEX_FILTER_ID));
        }
        argumentComposite.layout(true);
    }

    private void createArgumentsArea(Font font, Composite composite) {
        this.argumentsLabel = this.addLabel(composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterPattern, null));
        this.arguments = new Text(composite, 2052);
        GridData data = new GridData(4, 0x1000000, true, false);
        this.arguments.setLayoutData((Object)data);
        this.arguments.setFont(font);
        this.arguments.addModifyListener(e -> FilterTypeUtil.setValue(this.filter, FilterTypeUtil.ARGUMENTS, this.arguments.getText()));
        if (this.filter.hasStringArguments()) {
            this.arguments.setText((String)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.ARGUMENTS));
        }
        this.arguments.setEnabled(this.filter.hasStringArguments());
        this.setArgumentLabelEnabled();
        TextContentAdapter contentAdapter = new TextContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        this.fContentAssistField = new ContentAssistCommandAdapter((Control)this.arguments, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, null, new char[]{'\\', '[', '('}, true);
    }

    private void setArgumentLabelEnabled() {
        if (this.argumentsLabel != null) {
            Color color = this.argumentsLabel.getDisplay().getSystemColor(this.filter.hasStringArguments() ? 2 : 15);
            this.argumentsLabel.setForeground(color);
        }
    }

    Label addLabel(Composite composite, String text) {
        String delimiter = ":";
        Font font = composite.getFont();
        Label label = new Label(composite, 16384);
        label.setText(String.valueOf(text) + delimiter);
        GridData data = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        label.setFont(font);
        return label;
    }

    @Override
    public void selectionChanged() {
        if (this.arguments != null) {
            this.arguments.setEnabled(this.filter.hasStringArguments());
        }
        this.setArgumentLabelEnabled();
        if (this.fContentAssistField != null) {
            this.fContentAssistField.setEnabled(this.filter.getId().equals(REGEX_FILTER_ID));
        }
        this.description.setText(FilterTypeUtil.getDescriptor(this.filter.getId()).getDescription());
    }

    private void createDescriptionArea(Font font, Composite composite) {
        this.description = new Label(composite, 16448);
        this.description.setText(FilterTypeUtil.getDescriptor(this.filter.getId()).getDescription());
        GridData data = new GridData(4, 1, true, true);
        data.widthHint = 300;
        data.heightHint = 40;
        data.horizontalSpan = 2;
        this.description.setLayoutData((Object)data);
        this.description.setFont(font);
    }

    @Override
    public String validate() {
        return null;
    }

    @Override
    public StyledString formatStyledText(FilterCopy filter, StyledString.Styler fPlainStyler, StyledString.Styler fBoldStyler) {
        return new StyledString(filter.getArguments() != null ? filter.getArguments().toString() : "", fPlainStyler);
    }
}

