/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.graph;

import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gmf.runtime.draw2d.ui.graph.BorderNode;

public class ConstrainedEdge
extends Edge {
    public static String DEFAULT_ROUTING_STYLE = "Default";
    public static String ORTHOGONAL_ROUTING_STYLE = "Orthogonal";
    private String style = DEFAULT_ROUTING_STYLE;
    BorderNode sourceConstraint = null;
    BorderNode targetConstraint = null;
    PointList startingRoutedPoints = new PointList();
    PointList endingRoutedPoints = new PointList();

    public ConstrainedEdge(Node source, Node target) {
        this(null, source, target);
    }

    public ConstrainedEdge(Node source, Node target, int delta, int weight) {
        this(source, target);
        this.delta = delta;
        this.weight = weight;
    }

    public ConstrainedEdge(Object data, Node source, Node target) {
        super(data, source, target);
        if (source instanceof BorderNode) {
            this.sourceConstraint = (BorderNode)source;
            this.source = this.sourceConstraint.borderNodeParent;
            this.source.outgoing.add((Object)this);
            this.sourceConstraint.addOutgoingEdge(this);
        }
        if (target instanceof BorderNode) {
            this.targetConstraint = (BorderNode)target;
            this.target = this.targetConstraint.borderNodeParent;
            this.target.incoming.add((Object)this);
            this.targetConstraint.addIncomingEdge(this);
        }
        if (this.source.equals(this.target)) {
            throw new RuntimeException("Edges between border nodes on the same parent or border node and its parent are disallowed.");
        }
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void invert() {
        super.invert();
        if (this.sourceConstraint != null) {
            this.sourceConstraint.outgoingJointEdges.edges.remove((Object)this);
        }
        if (this.targetConstraint != null) {
            this.targetConstraint.incomingJointEdges.edges.remove((Object)this);
        }
        BorderNode temp = this.sourceConstraint;
        this.sourceConstraint = this.targetConstraint;
        this.targetConstraint = temp;
        if (this.sourceConstraint != null) {
            this.sourceConstraint.outgoingJointEdges.edges.add((Object)this);
        }
        if (this.targetConstraint != null) {
            this.targetConstraint.incomingJointEdges.edges.add((Object)this);
        }
    }
}

