/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import com.google.common.collect.Lists;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.operation.ShiftDirectBorderedNodesOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SetConnectionBendpointsAndLabelCommmand;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.internal.refresh.edge.SlidableAnchor;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.straighten.StraightenToAction;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;

public class StraightenToCommand
extends AbstractTransactionalCommand {
    private AbstractDiagramEdgeEditPart edgeEditPart;
    private int straightenType;
    private IGraphicalEditPart sourceEditPart;
    private IGraphicalEditPart targetEditPart;
    private boolean isSourceABorderNode;
    private boolean isTargetABorderNode;
    private boolean moveSource;
    private boolean isSpecificCase;
    private int deltaX = 0;
    private int deltaY = 0;

    public StraightenToCommand(AbstractDiagramEdgeEditPart edgeEditPart, int straightenType) {
        super(edgeEditPart.getEditingDomain(), StraightenToAction.getLabel(straightenType), null);
        this.edgeEditPart = edgeEditPart;
        this.straightenType = straightenType;
        if (edgeEditPart.getSource() instanceof IGraphicalEditPart) {
            this.sourceEditPart = (IGraphicalEditPart)edgeEditPart.getSource();
        }
        if (edgeEditPart.getTarget() instanceof IGraphicalEditPart) {
            this.targetEditPart = (IGraphicalEditPart)edgeEditPart.getTarget();
        }
    }

    public boolean canExecute() {
        boolean canExecute = false;
        Object model = this.edgeEditPart.getModel();
        if (model instanceof Edge && this.sourceEditPart != null && this.targetEditPart != null) {
            Edge edge = (Edge)model;
            EdgeQuery edgeQuery = new EdgeQuery(edge);
            boolean bl = canExecute = !edgeQuery.isEdgeWithTreeRoutingStyle();
            if (canExecute) {
                boolean bl2 = canExecute = !(this.sourceEditPart instanceof org.eclipse.gef.ConnectionEditPart) && !(this.targetEditPart instanceof org.eclipse.gef.ConnectionEditPart);
            }
            if (canExecute) {
                this.isSourceABorderNode = this.sourceEditPart instanceof AbstractDiagramBorderNodeEditPart;
                this.isTargetABorderNode = this.targetEditPart instanceof AbstractDiagramBorderNodeEditPart;
                int axis = this.getSourceAndTargetSameAxis();
                boolean bl3 = canExecute = axis != 0;
                if (canExecute) {
                    if (axis == 64 && (this.straightenType == 0 || this.straightenType == 1) || axis == 128 && (this.straightenType == 2 || this.straightenType == 3)) {
                        this.moveSource = this.isSourceWillBeMoved();
                    } else {
                        canExecute = false;
                    }
                }
            }
            if (canExecute) {
                boolean bl4 = canExecute = !this.isMovedNodeABorderNodeWithSeveralConnections();
            }
            if (canExecute) {
                boolean bl5 = canExecute = !this.isCentered();
            }
            if (canExecute) {
                canExecute = this.isNewLocationInParentBounds();
            }
            if (canExecute) {
                canExecute = !this.isOverlapped();
            }
        }
        return canExecute;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public void dispose() {
        this.edgeEditPart = null;
        this.sourceEditPart = null;
        this.targetEditPart = null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CommandResult commandResult = CommandResult.newOKCommandResult();
        if (this.edgeEditPart.getFigure() instanceof Connection && this.edgeEditPart.getModel() instanceof Edge) {
            CompositeCommand cc = new CompositeCommand(this.getLabel());
            Rectangle sourceBounds = this.getHandleBounds(this.sourceEditPart.getFigure());
            Rectangle targetBounds = this.getHandleBounds(this.targetEditPart.getFigure());
            Connection figure = (Connection)this.edgeEditPart.getFigure();
            Point firstPoint = figure.getPoints().getFirstPoint().getCopy();
            Point lastPoint = figure.getPoints().getLastPoint().getCopy();
            if (this.moveSource) {
                if (this.isSourceABorderNode) {
                    sourceBounds = sourceBounds.getTranslated(this.deltaX, this.deltaY);
                }
                if (this.isSpecificCase) {
                    this.computePointsInSpecificCase(firstPoint, lastPoint, sourceBounds, targetBounds);
                } else {
                    firstPoint = firstPoint.getTranslated(this.deltaX, this.deltaY);
                }
                this.completeCommand(cc, this.sourceEditPart, this.isSourceABorderNode, sourceBounds, targetBounds, firstPoint, lastPoint);
            } else {
                if (this.isTargetABorderNode) {
                    targetBounds = targetBounds.getTranslated(this.deltaX, this.deltaY);
                }
                if (this.isSpecificCase) {
                    this.computePointsInSpecificCase(firstPoint, lastPoint, sourceBounds, targetBounds);
                } else {
                    lastPoint = lastPoint.getTranslated(this.deltaX, this.deltaY);
                }
                this.completeCommand(cc, this.targetEditPart, this.isTargetABorderNode, sourceBounds, targetBounds, firstPoint, lastPoint);
            }
            IStatus status = cc.execute(monitor, info);
            if (status != null && !status.isOK()) {
                if (status.getSeverity() == 8) {
                    commandResult = CommandResult.newCancelledCommandResult();
                } else if (status.getSeverity() == 4) {
                    commandResult = CommandResult.newErrorCommandResult((Throwable)status.getException());
                }
            }
        }
        return commandResult;
    }

    private void computePointsInSpecificCase(Point firstPoint, Point lastPoint, Rectangle sourceBounds, Rectangle targetBounds) {
        if (this.straightenType == 0 || this.straightenType == 1) {
            firstPoint.setX(firstPoint.x).setY(sourceBounds.getCenter().y);
            lastPoint.setX(lastPoint.x).setY(targetBounds.getCenter().y);
        } else {
            firstPoint.setX(sourceBounds.getCenter().x).setY(firstPoint.y);
            lastPoint.setX(targetBounds.getCenter().x).setY(lastPoint.y);
        }
    }

    private void completeCommand(CompositeCommand command, IGraphicalEditPart editPartOnMovedSide, boolean isABorderNode, Rectangle sourceBounds, Rectangle targetBounds, Point firstPoint, Point lastPoint) {
        if (isABorderNode) {
            command.add((IUndoableOperation)CommandFactory.createICommand(this.getEditingDomain(), new ShiftDirectBorderedNodesOperation(Lists.newArrayList((Object[])new Node[]{(Node)editPartOnMovedSide.getModel()}), new Dimension(this.deltaX, this.deltaY))));
        }
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(this.getEditingDomain(), "");
        PrecisionPoint newSourceAnchor = BaseSlidableAnchor.getAnchorRelativeLocation((Point)firstPoint, (Rectangle)sourceBounds);
        scaCommand.setNewSourceTerminal(SlidableAnchor.composeTerminalString(newSourceAnchor));
        PrecisionPoint newTargetAnchor = BaseSlidableAnchor.getAnchorRelativeLocation((Point)lastPoint, (Rectangle)targetBounds);
        scaCommand.setNewTargetTerminal(SlidableAnchor.composeTerminalString(newTargetAnchor));
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((Edge)this.edgeEditPart.getModel())));
        command.add((IUndoableOperation)scaCommand);
        SetConnectionBendpointsAndLabelCommmand resetBendpointsCmd = new SetConnectionBendpointsAndLabelCommmand(this.getEditingDomain());
        resetBendpointsCmd.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)((Edge)this.edgeEditPart.getModel())));
        PointList newPointList = new PointList(2);
        newPointList.addPoint(firstPoint);
        newPointList.addPoint(lastPoint);
        resetBendpointsCmd.setNewPointList(newPointList, firstPoint, lastPoint);
        resetBendpointsCmd.setLabelsToUpdate((ConnectionEditPart)this.edgeEditPart);
        command.add((IUndoableOperation)resetBendpointsCmd);
    }

    private int getSourceAndTargetSameAxis() {
        int axis = 0;
        int sideOfSource = 0;
        if (this.isSourceABorderNode) {
            sideOfSource = ((IBorderItemEditPart)this.edgeEditPart.getSource()).getBorderItemLocator().getCurrentSideOfParent();
        } else if (this.edgeEditPart.getSource() instanceof GraphicalEditPart && this.edgeEditPart.getFigure() instanceof Connection) {
            Point firstPoint = ((Connection)this.edgeEditPart.getFigure()).getPoints().getFirstPoint();
            sideOfSource = this.getLocation(firstPoint, this.getHandleBounds(((GraphicalEditPart)this.edgeEditPart.getSource()).getFigure()));
        }
        int sideOfTarget = 0;
        if (this.isTargetABorderNode) {
            sideOfTarget = ((IBorderItemEditPart)this.edgeEditPart.getTarget()).getBorderItemLocator().getCurrentSideOfParent();
        } else if (this.edgeEditPart.getTarget() instanceof GraphicalEditPart && this.edgeEditPart.getFigure() instanceof Connection) {
            Point lastPoint = ((Connection)this.edgeEditPart.getFigure()).getPoints().getLastPoint();
            sideOfTarget = this.getLocation(lastPoint, this.getHandleBounds(((GraphicalEditPart)this.edgeEditPart.getTarget()).getFigure()));
        }
        if (this.isOnHorizontalAxis(sideOfSource) && this.isOnHorizontalAxis(sideOfTarget)) {
            axis = 64;
        } else if (this.isOnVerticalAxis(sideOfSource) && this.isOnVerticalAxis(sideOfTarget)) {
            axis = 128;
        }
        return axis;
    }

    private boolean isSourceWillBeMoved() {
        Point targetPoint;
        PointList pointList;
        Point sourcePoint;
        boolean isSourceWillBeMoved = false;
        if (this.isSourceABorderNode) {
            sourcePoint = ((IBorderItemEditPart)this.edgeEditPart.getSource()).getFigure().getBounds().getCenter();
        } else if (this.edgeEditPart.getFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            pointList = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)this.edgeEditPart.getFigure()).getPoints().getCopy();
            sourcePoint = pointList.getFirstPoint();
        } else {
            sourcePoint = new Point();
        }
        if (this.isTargetABorderNode) {
            targetPoint = ((IBorderItemEditPart)this.edgeEditPart.getTarget()).getFigure().getBounds().getCenter();
        } else if (this.edgeEditPart.getFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            pointList = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)this.edgeEditPart.getFigure()).getPoints().getCopy();
            targetPoint = pointList.getLastPoint();
        } else {
            targetPoint = new Point();
        }
        if (this.straightenType == 2) {
            if (sourcePoint.x > targetPoint.x) {
                isSourceWillBeMoved = true;
            }
        } else if (this.straightenType == 3) {
            if (sourcePoint.x < targetPoint.x) {
                isSourceWillBeMoved = true;
            }
        } else if (this.straightenType == 0) {
            if (sourcePoint.y > targetPoint.y) {
                isSourceWillBeMoved = true;
            }
        } else if (sourcePoint.y < targetPoint.y) {
            isSourceWillBeMoved = true;
        }
        return isSourceWillBeMoved;
    }

    private boolean isMovedNodeABorderNodeWithSeveralConnections() {
        boolean result = false;
        result = this.moveSource ? this.isSourceABorderNode && this.sourceEditPart.getSourceConnections().size() + this.sourceEditPart.getTargetConnections().size() > 1 : this.isTargetABorderNode && this.targetEditPart.getSourceConnections().size() + this.targetEditPart.getTargetConnections().size() > 1;
        return result;
    }

    private boolean isCentered() {
        boolean isCentered = false;
        if (this.edgeEditPart.getFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            boolean isExceptionCase;
            AbstractDiagramEdgeEditPart.ViewEdgeFigure figure = (AbstractDiagramEdgeEditPart.ViewEdgeFigure)this.edgeEditPart.getFigure();
            boolean bl = isExceptionCase = this.isSourceABorderNode && this.isTargetABorderNode && figure.isSourceCentered() && figure.isTargetCentered();
            if (isExceptionCase) {
                this.isSpecificCase = true;
            } else {
                isCentered = new ConnectionEditPartQuery(this.edgeEditPart).isEdgeWithObliqueRoutingStyle() ? figure.isSourceCentered() || figure.isTargetCentered() : (this.moveSource ? figure.isSourceCentered() : figure.isTargetCentered());
            }
        }
        return isCentered;
    }

    private boolean isNewLocationInParentBounds() {
        boolean isNewLocationInParentBounds = false;
        if (this.edgeEditPart.getFigure() instanceof Connection) {
            Connection figure = (Connection)this.edgeEditPart.getFigure();
            Point firstPoint = figure.getPoints().getFirstPoint().getCopy();
            Point lastPoint = figure.getPoints().getLastPoint().getCopy();
            if (this.isSpecificCase) {
                firstPoint = this.getHandleBounds(this.sourceEditPart.getFigure()).getCenter();
                lastPoint = this.getHandleBounds(this.targetEditPart.getFigure()).getCenter();
            }
            if (this.moveSource) {
                if (this.straightenType == 0 || this.straightenType == 1) {
                    this.deltaY = lastPoint.y - firstPoint.y;
                } else if (this.straightenType == 2 || this.straightenType == 3) {
                    this.deltaX = lastPoint.x - firstPoint.x;
                }
                if (this.isSourceABorderNode) {
                    Rectangle parentBorderNodeBounds = this.getHandleBounds(((GraphicalEditPart)this.sourceEditPart.getParent()).getFigure());
                    Rectangle borderNodeBounds = this.getHandleBounds(this.sourceEditPart.getFigure());
                    borderNodeBounds = borderNodeBounds.getTranslated(this.deltaX, this.deltaY);
                    if (this.straightenType == 0 || this.straightenType == 1) {
                        if (parentBorderNodeBounds.y <= borderNodeBounds.y && borderNodeBounds.y + borderNodeBounds.height <= parentBorderNodeBounds.y + parentBorderNodeBounds.height) {
                            isNewLocationInParentBounds = true;
                        }
                    } else if ((this.straightenType == 2 || this.straightenType == 3) && parentBorderNodeBounds.x <= borderNodeBounds.x && borderNodeBounds.x + borderNodeBounds.width <= parentBorderNodeBounds.x + parentBorderNodeBounds.width) {
                        isNewLocationInParentBounds = true;
                    }
                } else {
                    Rectangle bounds = this.getHandleBounds(this.sourceEditPart.getFigure());
                    if (this.straightenType == 0 || this.straightenType == 1) {
                        if (bounds.y <= lastPoint.y && lastPoint.y <= bounds.y + bounds.height) {
                            isNewLocationInParentBounds = true;
                        }
                    } else if ((this.straightenType == 2 || this.straightenType == 3) && bounds.x <= lastPoint.x && lastPoint.x <= bounds.x + bounds.width) {
                        isNewLocationInParentBounds = true;
                    }
                }
            } else {
                if (this.straightenType == 0 || this.straightenType == 1) {
                    this.deltaY = firstPoint.y - lastPoint.y;
                } else if (this.straightenType == 2 || this.straightenType == 3) {
                    this.deltaX = firstPoint.x - lastPoint.x;
                }
                if (this.isTargetABorderNode) {
                    Rectangle parentBorderNodeBounds = this.getHandleBounds(((GraphicalEditPart)this.targetEditPart.getParent()).getFigure());
                    Rectangle borderNodeBounds = this.getHandleBounds(this.targetEditPart.getFigure());
                    borderNodeBounds = borderNodeBounds.getTranslated(this.deltaX, this.deltaY);
                    if (this.straightenType == 0 || this.straightenType == 1) {
                        if (parentBorderNodeBounds.y <= borderNodeBounds.y && borderNodeBounds.y + borderNodeBounds.height <= parentBorderNodeBounds.y + parentBorderNodeBounds.height) {
                            isNewLocationInParentBounds = true;
                        }
                    } else if ((this.straightenType == 2 || this.straightenType == 3) && parentBorderNodeBounds.x <= borderNodeBounds.x && borderNodeBounds.x + borderNodeBounds.width <= parentBorderNodeBounds.x + parentBorderNodeBounds.width) {
                        isNewLocationInParentBounds = true;
                    }
                } else {
                    Rectangle bounds = this.getHandleBounds(this.targetEditPart.getFigure());
                    if (this.straightenType == 0 || this.straightenType == 1) {
                        if (bounds.y <= firstPoint.y && firstPoint.y <= bounds.y + bounds.height) {
                            isNewLocationInParentBounds = true;
                        }
                    } else if ((this.straightenType == 2 || this.straightenType == 3) && bounds.x <= firstPoint.x && firstPoint.x <= bounds.x + bounds.width) {
                        isNewLocationInParentBounds = true;
                    }
                }
            }
        }
        return isNewLocationInParentBounds;
    }

    private boolean isOverlapped() {
        boolean isOverlapped = false;
        if (this.moveSource && this.isSourceABorderNode) {
            if (this.sourceEditPart.getModel() instanceof Node) {
                isOverlapped = this.isOverlapped((Node)this.sourceEditPart.getModel());
            }
        } else if (!this.moveSource && this.isTargetABorderNode && this.targetEditPart.getModel() instanceof Node) {
            isOverlapped = this.isOverlapped((Node)this.targetEditPart.getModel());
        }
        return isOverlapped;
    }

    private boolean isOverlapped(Node node) {
        boolean isOverlapped = false;
        Node parentNode = (Node)node.eContainer();
        CanonicalDBorderItemLocator borderItemLocator = new CanonicalDBorderItemLocator(parentNode, 29);
        borderItemLocator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        if (layoutConstraint instanceof Location) {
            Rectangle constraint;
            if (layoutConstraint instanceof Bounds) {
                Bounds bounds = (Bounds)layoutConstraint;
                constraint = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            } else {
                Location location = (Location)layoutConstraint;
                constraint = new Rectangle(location.getX(), location.getY(), -1, -1);
            }
            constraint.translate(this.deltaX, this.deltaY);
            Point originalLocation = constraint.getLocation();
            Point parentAbsoluteLocation = GMFHelper.getAbsoluteLocation(parentNode);
            constraint.translate(parentAbsoluteLocation.x, parentAbsoluteLocation.y);
            Point realLocation = borderItemLocator.getValidLocation(constraint, node, Lists.newArrayList((Object[])new Node[]{node}));
            Dimension d = realLocation.getDifference(parentAbsoluteLocation);
            realLocation.setLocation(new Point(d.width, d.height));
            if (!originalLocation.equals((Object)realLocation)) {
                isOverlapped = true;
            }
        }
        return isOverlapped;
    }

    private Rectangle getHandleBounds(IFigure figure) {
        Rectangle bounds = figure instanceof HandleBounds ? ((HandleBounds)figure).getHandleBounds() : figure.getBounds();
        return bounds;
    }

    private boolean isOnHorizontalAxis(int side) {
        return (side & 0x10) > 0 || (side & 8) > 0;
    }

    private boolean isOnVerticalAxis(int side) {
        return (side & 1) > 0 || (side & 4) > 0;
    }

    private int getLocation(Point point, Rectangle rect) {
        int side = rect.getPosition(point);
        if (side == 0) {
            if (point.x() == rect.x) {
                side = 8;
            } else if (point.x() == rect.x + rect.width) {
                side = 16;
            }
            if (point.y() == rect.y) {
                side |= 1;
            } else if (point.y() == rect.y + rect.height) {
                side |= 4;
            }
        }
        return side;
    }
}

