/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.DEdgeNameSelectionFeedbackEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ResizableShapeLabelEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusPropertyHandlerEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractGeneratedDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.locator.EdgeLabelLocator;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusElementTypes;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.policy.CompoundEditPolicy;
import org.eclipse.sirius.ext.base.Option;

public class AbstractDEdgeNameEditPart
extends AbstractGeneratedDiagramNameEditPart
implements ITextAwareEditPart {
    public AbstractDEdgeNameEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ResizableShapeLabelEditPolicy());
        EditPolicy currentSelectionEditPolicy = this.getEditPolicy("Selection Feedback");
        DEdgeNameSelectionFeedbackEditPolicy selectionFeedBackEditPolicy = new DEdgeNameSelectionFeedbackEditPolicy();
        if (currentSelectionEditPolicy != null) {
            CompoundEditPolicy compoundEditPolicy = new CompoundEditPolicy();
            compoundEditPolicy.addEditPolicy(currentSelectionEditPolicy);
            compoundEditPolicy.addEditPolicy((EditPolicy)selectionFeedBackEditPolicy);
            this.removeEditPolicy("Selection Feedback");
            this.installEditPolicy("Selection Feedback", compoundEditPolicy);
        } else {
            this.installEditPolicy("Selection Feedback", (EditPolicy)selectionFeedBackEditPolicy);
        }
        this.removeEditPolicy("PropertyHandlerPolicy");
        this.installEditPolicy("PropertyHandlerPolicy", (EditPolicy)new SiriusPropertyHandlerEditPolicy());
    }

    public void setLabel(SiriusWrapLabel figure) {
        this.unregisterVisuals();
        this.setFigure((IFigure)figure);
        this.defaultText = this.getLabelTextHelper((IFigure)figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    @Override
    protected IElementType getParserElementType() {
        return SiriusElementTypes.DEdge_4001;
    }

    @Override
    protected void setManager(DirectEditManager manager) {
        DEdge edge = (DEdge)this.resolveSemanticElement();
        Option edgeMapping = new IEdgeMappingQuery(edge.getActualMapping()).getEdgeMapping();
        if (edgeMapping.some() && ((EdgeMapping)edgeMapping.get()).getLabelDirectEdit() != null) {
            this.manager = manager;
        }
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        if (this.resolveSemanticElement() instanceof DEdge) {
            Object feature = event.getFeature();
            if (DiagramPackage.eINSTANCE.getDDiagramElementContainer_OwnedStyle() == feature) {
                this.refreshVisuals();
            }
            if (NotationPackage.eINSTANCE.getNode_LayoutConstraint().equals(feature)) {
                this.refreshBounds();
            }
            super.handleNotificationEvent(event);
        }
    }

    protected IFigure createFigure() {
        return null;
    }

    @Override
    public void setLabel(IFigure figure) {
        if (figure instanceof SiriusWrapLabel) {
            this.setLabel((SiriusWrapLabel)figure);
        }
    }

    public void refreshBounds() {
        this.handleResizableRefreshBounds();
    }

    private void handleResizableRefreshBounds() {
        int dx = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int dy = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Rectangle rectangle = new Rectangle(dx, dy, width, height);
        if (this.getParent() instanceof AbstractConnectionEditPart) {
            ((AbstractGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new EdgeLabelLocator(this.getFigure().getParent(), rectangle, this.getKeyPoint()));
        }
    }
}

