/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.straighten;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.requests.StraightenToRequest;
import org.eclipse.ui.IWorkbenchPage;

public class StraightenToAction
extends DiagramAction {
    public static final int TO_TOP = 0;
    public static final int TO_BOTTOM = 1;
    public static final int TO_LEFT = 2;
    public static final int TO_RIGHT = 3;
    private int straightenType;

    protected StraightenToAction(IWorkbenchPage workbenchPage, int straightenType) {
        super(workbenchPage);
        this.straightenType = straightenType;
        this.setText(StraightenToAction.getLabel(straightenType));
        this.setToolTipText(StraightenToAction.getTooltip(straightenType));
    }

    public static String getLabel(int straightenType) {
        String label = "";
        switch (straightenType) {
            case 0: {
                label = Messages.StraightenToAction_toTopLabel;
                break;
            }
            case 1: {
                label = Messages.StraightenToAction_toBottomLabel;
                break;
            }
            case 2: {
                label = Messages.StraightenToAction_toLeftLabel;
                break;
            }
            case 3: {
                label = Messages.StraightenToAction_toRightLabel;
                break;
            }
        }
        return label;
    }

    public static String getTooltip(int straightenType) {
        String tooltip = "";
        switch (straightenType) {
            case 0: {
                tooltip = Messages.StraightenToAction_toTopTooltip;
                break;
            }
            case 1: {
                tooltip = Messages.StraightenToAction_toBottomTooltip;
                break;
            }
            case 2: {
                tooltip = Messages.StraightenToAction_toLeftTooltip;
                break;
            }
            case 3: {
                tooltip = Messages.StraightenToAction_toRightTooltip;
                break;
            }
        }
        return tooltip;
    }

    public static StraightenToAction createStraightenToTopAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 0);
        action.setId("straightenToTop");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenToTop.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static StraightenToAction createStraightenToBottomAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 1);
        action.setId("straightenToBottom");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenToBottom.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static StraightenToAction createStraightenToLeftAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 2);
        action.setId("straightenToLeft");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenToLeft.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    public static StraightenToAction createStraightenToRightAction(IWorkbenchPage workbenchPage) {
        StraightenToAction action = new StraightenToAction(workbenchPage, 3);
        action.setId("straightenToRight");
        ImageDescriptor bundledImageDescriptor = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/straightenToRight.png");
        action.setImageDescriptor(bundledImageDescriptor);
        action.setHoverImageDescriptor(bundledImageDescriptor);
        return action;
    }

    protected Request createTargetRequest() {
        StraightenToRequest straightenRequest = new StraightenToRequest();
        straightenRequest.setStraightenType(this.straightenType);
        return straightenRequest;
    }

    protected void updateTargetRequest() {
        StraightenToRequest straightenRequest = (StraightenToRequest)this.getTargetRequest();
        straightenRequest.setStraightenType(this.straightenType);
    }

    protected Command getCommand() {
        CompoundCommand straightenEdgesCmd = new CompoundCommand(Messages.StraightenToAction_commandLabel);
        List operationSet = this.getOperationSet();
        if (!operationSet.isEmpty()) {
            for (Object object : operationSet) {
                if (!(object instanceof ConnectionEditPart)) continue;
                straightenEdgesCmd.add(((ConnectionEditPart)object).getCommand(this.getTargetRequest()));
            }
        }
        return straightenEdgesCmd;
    }

    protected List<?> createOperationSet() {
        List selection = this.getSelectedObjects();
        if (!Iterables.all((Iterable)selection, (Predicate)Predicates.instanceOf(AbstractDiagramEdgeEditPart.class))) {
            selection = Collections.EMPTY_LIST;
        }
        return selection;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected boolean isOperationHistoryListener() {
        return true;
    }
}

