/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions;

import java.lang.reflect.Field;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.ColorPropertyContributionItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class TabbarColorPropertyContributionItem
extends ColorPropertyContributionItem {
    private static final String FIELD_NAME = "lastColor";
    private IWorkbenchPart representationPart;

    public TabbarColorPropertyContributionItem(IWorkbenchPage workbenchPage, String id, String propertyId, String propertyName, String toolTipText, ImageData basicImageData, ImageData disabledBasicImageData) {
        super(workbenchPage, id, propertyId, propertyName, toolTipText, basicImageData, disabledBasicImageData);
    }

    @Override
    protected void init() {
        super.init();
        RGB rgb = null;
        String color = this.getLastColor();
        if (color != null) {
            rgb = FigureUtilities.integerToRGB((Integer)Integer.parseInt(color));
        }
        TabbarColorPropertyContributionItem.setElement(this, new ColorMenuImageDescriptor(this.getBasicImageData(), rgb).createImage(), "overlyedImage");
        TabbarColorPropertyContributionItem.setElement(this, new ColorMenuImageDescriptor((ImageData)TabbarColorPropertyContributionItem.getElement(this, "disabledBasicImageData"), rgb).createImage(), "disabledBasicImage");
    }

    public static TabbarColorPropertyContributionItem createFontColorContributionItem(IWorkbenchPage workbenchPage) {
        String propertyName = DiagramUIActionsMessages.PropertyDescriptorFactory_FontColor;
        String toolTipText = DiagramUIActionsMessages.ColorChangeActionMenu_fontColor;
        ImageData basicImageData = DiagramUIActionsPluginImages.DESC_FONT_COLOR.getImageData();
        ImageData disabledBasicImageData = DiagramUIActionsPluginImages.DESC_FONT_COLOR_DISABLED.getImageData();
        return new TabbarColorPropertyContributionItem(workbenchPage, "fontColorContributionItem", Properties.ID_FONTCOLOR, propertyName, toolTipText, basicImageData, disabledBasicImageData);
    }

    public static TabbarColorPropertyContributionItem createLineColorContributionItem(IWorkbenchPage workbenchPage) {
        String propertyName = DiagramUIActionsMessages.PropertyDescriptorFactory_LineColor;
        String toolTipText = DiagramUIActionsMessages.ColorChangeActionMenu_lineColor;
        ImageData basicImageData = DiagramUIActionsPluginImages.DESC_LINE_COLOR.getImageData();
        ImageData disabledBasicImageData = DiagramUIActionsPluginImages.DESC_LINE_COLOR_DISABLED.getImageData();
        return new TabbarColorPropertyContributionItem(workbenchPage, "lineColorContributionItem", Properties.ID_LINECOLOR, propertyName, toolTipText, basicImageData, disabledBasicImageData);
    }

    public static TabbarColorPropertyContributionItem createFillColorContributionItem(IWorkbenchPage workbenchPage) {
        String propertyName = DiagramUIActionsMessages.PropertyDescriptorFactory_FillColor;
        String toolTipText = DiagramUIActionsMessages.ColorChangeActionMenu_fillColor;
        ImageData basicImageData = DiagramUIActionsPluginImages.DESC_FILL_COLOR.getImageData();
        ImageData disabledBasicImageData = DiagramUIActionsPluginImages.DESC_FILL_COLOR_DISABLED.getImageData();
        return new TabbarColorPropertyContributionItem(workbenchPage, "fillColorContributionItem", Properties.ID_FILLCOLOR, propertyName, toolTipText, basicImageData, disabledBasicImageData);
    }

    public void setLastColor(String lastColor) {
        TabbarColorPropertyContributionItem.setElement(this, Integer.parseInt(lastColor), FIELD_NAME);
    }

    public String getLastColor() {
        Integer lastColor = (Integer)TabbarColorPropertyContributionItem.getElement(this, FIELD_NAME);
        if (lastColor != null) {
            return lastColor.toString();
        }
        return null;
    }

    public void refresh() {
        IWorkbenchPart part = this.getWorkbenchPart();
        if (this.representationPart != null && !this.representationPart.equals(part)) {
            return;
        }
        super.refresh();
    }

    public void setActionWorkbenchPart(IWorkbenchPart contributionItemWorkbenchPart) {
        this.representationPart = contributionItemWorkbenchPart;
    }

    @Override
    public void dispose() {
        this.representationPart = null;
        super.dispose();
    }

    private static Object getElement(ColorPropertyContributionItem item, String featureName) {
        try {
            Field field = ColorPropertyContributionItem.class.getDeclaredField(featureName);
            field.setAccessible(true);
            return field.get((Object)item);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return null;
    }

    private static void setElement(ColorPropertyContributionItem item, Object object, String featureName) {
        try {
            Field field = ColorPropertyContributionItem.class.getDeclaredField(featureName);
            field.setAccessible(true);
            Object fieldItem = field.get((Object)item);
            if (fieldItem instanceof Image && fieldItem != object) {
                ((Image)fieldItem).dispose();
            }
            field.set((Object)item, object);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
    }

    public static /* bridge */ /* synthetic */ ColorPropertyContributionItem createLineColorContributionItem(IWorkbenchPage iWorkbenchPage) {
        return TabbarColorPropertyContributionItem.createLineColorContributionItem(iWorkbenchPage);
    }

    public static /* bridge */ /* synthetic */ ColorPropertyContributionItem createFontColorContributionItem(IWorkbenchPage iWorkbenchPage) {
        return TabbarColorPropertyContributionItem.createFontColorContributionItem(iWorkbenchPage);
    }

    public static /* bridge */ /* synthetic */ ColorPropertyContributionItem createFillColorContributionItem(IWorkbenchPage iWorkbenchPage) {
        return TabbarColorPropertyContributionItem.createFillColorContributionItem(iWorkbenchPage);
    }

    private static class ColorMenuImageDescriptor
    extends CompositeImageDescriptor {
        private static final Point ICON_SIZE = new Point(16, 16);
        private ImageData basicImgData;
        private RGB rgb;

        public ColorMenuImageDescriptor(ImageData basicImgData, RGB rgb) {
            this.basicImgData = basicImgData;
            this.rgb = rgb;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.basicImgData, 0, 0);
            if (this.rgb != null) {
                ImageData colorBar = new ImageData(14, 4, 1, new PaletteData(new RGB[]{this.rgb}));
                this.drawImage(colorBar, 1, height - 4);
            }
        }

        protected Point getSize() {
            return ICON_SIZE;
        }
    }
}

