/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.format.semantic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.formatdata.AbstractFormatData;
import org.eclipse.sirius.diagram.formatdata.EdgeFormatData;
import org.eclipse.sirius.diagram.formatdata.NodeFormatData;
import org.eclipse.sirius.diagram.ui.tools.api.format.AbstractSiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataHelper;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.internal.format.AdvancedSiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.AbstractSemanticFormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.SemanticEdgeFormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.SemanticNodeFormatDataKey;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class SiriusFormatDataManagerForSemanticElements
extends AbstractSiriusFormatDataManager
implements AdvancedSiriusFormatDataManager {
    private static final SiriusFormatDataManagerForSemanticElements INSTANCE = new SiriusFormatDataManagerForSemanticElements();
    private final Map<SemanticNodeFormatDataKey, NodeFormatData> nodeFormatDataMap = new HashMap<SemanticNodeFormatDataKey, NodeFormatData>();
    private final Map<SemanticEdgeFormatDataKey, EdgeFormatData> edgeFormatDataMap = new HashMap<SemanticEdgeFormatDataKey, EdgeFormatData>();

    @Override
    public void addFormatData(FormatDataKey key, AbstractFormatData formatData) {
        if (!this.checkKeyType(key)) {
            formatData.setId(null);
            return;
        }
        if (key instanceof SemanticNodeFormatDataKey) {
            if (formatData instanceof NodeFormatData) {
                this.nodeFormatDataMap.put((SemanticNodeFormatDataKey)key, (NodeFormatData)formatData);
            }
        } else if (key instanceof SemanticEdgeFormatDataKey && formatData instanceof EdgeFormatData) {
            this.edgeFormatDataMap.put((SemanticEdgeFormatDataKey)key, (EdgeFormatData)formatData);
        }
    }

    @Override
    public AbstractFormatData getFormatData(FormatDataKey key) {
        AbstractFormatData result = null;
        if (this.checkKeyType(key)) {
            if (key instanceof SemanticNodeFormatDataKey) {
                result = (AbstractFormatData)this.nodeFormatDataMap.get(key);
            } else if (key instanceof SemanticEdgeFormatDataKey) {
                result = (AbstractFormatData)this.edgeFormatDataMap.get(key);
            }
        }
        return result;
    }

    private boolean checkKeyType(FormatDataKey key) {
        return key instanceof SemanticNodeFormatDataKey || key instanceof SemanticEdgeFormatDataKey;
    }

    public SiriusFormatDataManager getInstance() {
        return INSTANCE;
    }

    @Override
    public FormatDataKey createKey(DSemanticDecorator semanticDecorator) {
        AbstractSemanticFormatDataKey result = null;
        EObject realSemanticElement = semanticDecorator.getTarget();
        if (semanticDecorator instanceof DEdge) {
            result = new SemanticEdgeFormatDataKey(realSemanticElement);
        } else if (semanticDecorator instanceof AbstractDNode || semanticDecorator instanceof DDiagram) {
            result = new SemanticNodeFormatDataKey(realSemanticElement);
        }
        return result;
    }

    @Override
    public boolean containsData() {
        return !this.nodeFormatDataMap.isEmpty() || !this.edgeFormatDataMap.isEmpty();
    }

    @Override
    public void clearFormatData() {
        this.nodeFormatDataMap.clear();
        this.edgeFormatDataMap.clear();
    }

    public Map<SemanticEdgeFormatDataKey, EdgeFormatData> getEdgeFormatData() {
        return this.edgeFormatDataMap;
    }

    @Override
    public Map<? extends FormatDataKey, ? extends NodeFormatData> getRootNodeFormatData() {
        return FormatDataHelper.INSTANCE.getRootFormatData(this.nodeFormatDataMap);
    }

    public Map<SemanticNodeFormatDataKey, NodeFormatData> getNodeFormatData() {
        return this.nodeFormatDataMap;
    }
}

