/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.part;

import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemsAwareFreeFormLayer;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.gmf.runtime.gef.ui.internal.editparts.AnimatableZoomManager;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.DConnectionLayerEx;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.part.SiriusScroller;
import org.eclipse.sirius.diagram.ui.tools.internal.handler.SiriusAnimatableZoomManager;

public class DDiagramRootEditPart
extends RenderedDiagramRootEditPart {
    private SiriusAnimatableZoomManager siriusZoomManager;
    private double[] siriusZoomLevels = new double[]{0.05, 0.1, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 4.0};

    public DDiagramRootEditPart(MeasurementUnit mu) {
        super(mu);
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        layeredPane.add((IFigure)new BorderItemsAwareFreeFormLayer(), (Object)"Primary Layer");
        layeredPane.add((IFigure)new DConnectionLayerEx(), (Object)"Connection Layer");
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Decoration Printable Layer");
        return layeredPane;
    }

    protected ScalableFreeformLayeredPane createScaledLayers() {
        ScalableFreeformLayeredPane layers = super.createScaledLayers();
        FreeformLayer feedbackLayer = new FreeformLayer();
        feedbackLayer.setEnabled(false);
        layers.add((IFigure)feedbackLayer, (Object)"Scaled Feedback Layer");
        return layers;
    }

    public Object getAdapter(Class key) {
        if (key == AutoexposeHelper.class) {
            return new SiriusScroller((GraphicalEditPart)this, SiriusScroller.VIEWPOINT_SCROLLER_INSETS);
        }
        return super.getAdapter(key);
    }

    public ZoomManager getZoomManager() {
        if (this.siriusZoomManager == null) {
            this.siriusZoomManager = new SiriusAnimatableZoomManager((ScalableFigure)this.getScaledLayers(), (Viewport)this.getFigure());
            this.siriusZoomManager.setZoomLevels(this.siriusZoomLevels);
            this.refreshEnableZoomAnimation(this.siriusZoomManager);
        }
        return this.siriusZoomManager;
    }

    public void zoomIn() {
        this.getZoomManager().zoomIn();
    }

    public void zoomIn(Point center) {
        if (this.getZoomManager() instanceof AnimatableZoomManager) {
            ((AnimatableZoomManager)this.getZoomManager()).zoomTo(this.getZoomManager().getNextZoomLevel(), center);
        }
    }

    public void zoomOut() {
        this.getZoomManager().zoomOut();
    }

    public void zoomOut(Point center) {
        if (this.getZoomManager() instanceof AnimatableZoomManager) {
            ((AnimatableZoomManager)this.getZoomManager()).zoomTo(this.getZoomManager().getPreviousZoomLevel(), center);
        }
    }

    public void zoomTo(double zoom, Point center) {
        if (this.getZoomManager() instanceof AnimatableZoomManager) {
            ((AnimatableZoomManager)this.getZoomManager()).zoomTo(zoom, center);
        }
    }

    public void zoomTo(Rectangle rect) {
        this.getZoomManager().zoomTo(rect);
    }

    private void refreshEnableZoomAnimation(ZoomManager zoomMangr) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getPreferencesHint().getPreferenceStore();
        boolean animatedZoom = preferenceStore.getBoolean("Global.enableAnimatedZoom");
        zoomMangr.setZoomAnimationStyle(animatedZoom ? 1 : 0);
    }
}

