/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.provider;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.ui.tools.api.dialog.FeatureEditorDialog;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.exception.LockedInstanceException;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.CellUpdater;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.provider.Messages;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableTreeViewer;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableCellEditorFocusListener;
import org.eclipse.sirius.tools.api.interpreter.IInterpreterMessages;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class DFeatureColumnEditingSupport
extends EditingSupport {
    private final DFeatureColumn featureColumn;
    private final TransactionalEditingDomain editingDomain;
    private final ModelAccessor accessor;
    private final ITableCommandFactory tableCommandFactory;
    private final AbstractDTableEditor tableEditor;
    private final AdapterFactory adapterFactory;

    public DFeatureColumnEditingSupport(ColumnViewer viewer, DFeatureColumn featureColumn, TransactionalEditingDomain editingDomain, ModelAccessor accessor, ITableCommandFactory tableCommandFactory, AbstractDTableEditor tableEditor) {
        super(viewer);
        this.featureColumn = featureColumn;
        this.editingDomain = editingDomain;
        this.accessor = accessor;
        this.tableCommandFactory = tableCommandFactory;
        this.tableEditor = tableEditor;
        ArrayList<ComposedAdapterFactory> factories = new ArrayList<ComposedAdapterFactory>();
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        factories.add(new ComposedAdapterFactory(DialectUIManager.INSTANCE.createAdapterFactory()));
        this.adapterFactory = new ComposedAdapterFactory(factories);
    }

    protected boolean canEdit(Object element) {
        boolean result = false;
        if (element instanceof DLine) {
            DLine line = (DLine)element;
            boolean canEdit = true;
            Option optCell = TableHelper.getCell((DLine)line, (DColumn)this.featureColumn);
            if (optCell.some()) {
                DCell cell = (DCell)optCell.get();
                CellUpdater updater = cell.getUpdater();
                if (updater != null && updater.getCanEdit() != null && updater.getCanEdit().length() > 0) {
                    IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)cell.getTarget());
                    try {
                        canEdit = interpreter.evaluateBoolean(cell.getTarget(), updater.getCanEdit());
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)updater, (EStructuralFeature)DescriptionPackage.eINSTANCE.getCellUpdater_CanEdit(), (Throwable)e);
                    }
                }
                result = canEdit && this.getAuthority().canEditFeature(cell.getTarget(), this.getFeatureName()) && this.getAuthority().canEditInstance((EObject)line);
            }
        }
        return result;
    }

    protected CellEditor getCellEditor(Object element) {
        Option editedCell;
        if (element instanceof DLine && (editedCell = TableHelper.getCell((DLine)((DLine)element), (DColumn)this.featureColumn)).some()) {
            CellUpdater updater = ((DCell)editedCell.get()).getUpdater();
            boolean directEdit = updater != null && updater.getDirectEdit() != null;
            return this.getBestCellEditor(((DCell)editedCell.get()).getTarget(), directEdit);
        }
        return null;
    }

    protected Object getValue(Object element) {
        Object result = null;
        if (element instanceof DLine) {
            Option optEditedCell;
            block14: {
                optEditedCell = TableHelper.getCell((DLine)((DLine)element), (DColumn)this.featureColumn);
                if (optEditedCell.some()) break block14;
                return null;
            }
            try {
                DCell editedCell = (DCell)optEditedCell.get();
                EObject featureParent = editedCell.getTarget();
                boolean directEdit = false;
                CellUpdater updater = editedCell.getUpdater();
                if (updater != null && updater.getDirectEdit() != null) {
                    directEdit = true;
                }
                result = directEdit ? editedCell.getLabel() : this.getAccessor().eGet(featureParent, this.getFeatureName());
                if (!this.isEReference(featureParent) || directEdit) {
                    EClassifier eClassifier = this.getEClassifier(featureParent);
                    if (eClassifier instanceof EEnum && !(this.getCellEditor(element) instanceof ExtendedComboBoxCellEditor)) {
                        int index = 0;
                        if (result instanceof String) {
                            index = this.getIndex((EEnum)eClassifier, (String)result);
                        } else if (result instanceof Enumerator) {
                            index = this.getIndex((EEnum)eClassifier, ((Enumerator)result).getLiteral());
                        }
                        result = index;
                    } else if (result != null) {
                        if (!(result instanceof Boolean) && !(result instanceof Enumerator)) {
                            result = result.toString();
                        }
                    } else {
                        result = "";
                    }
                }
            }
            catch (FeatureNotFoundException e) {
                SiriusPlugin.getDefault().error(Messages.DFeatureColumnEditingSupport_errorGettingPropertyValue, (Throwable)e);
            }
        }
        return result;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof DLine) {
            DLine line = (DLine)element;
            Option optEditedCell = TableHelper.getCell((DLine)line, (DColumn)this.featureColumn);
            if (!optEditedCell.some()) {
                return;
            }
            DCell editedCell = (DCell)optEditedCell.get();
            EObject featureParent = editedCell.getTarget();
            EClassifier eClassifier = this.getEClassifier(featureParent);
            Object tempValue = value;
            if (eClassifier instanceof EEnum) {
                if (value instanceof Enumerator) {
                    tempValue = ((Enumerator)value).getValue();
                } else if (value != null) {
                    tempValue = ((EEnumLiteral)((EEnum)eClassifier).getELiterals().get(((Integer)value).intValue())).getValue();
                }
            } else if (value instanceof String && eClassifier != null) {
                try {
                    if (eClassifier instanceof EDataType) {
                        tempValue = eClassifier.getEPackage().getEFactoryInstance().createFromString((EDataType)eClassifier, (String)value);
                    } else if ("UnlimitedNatural".equals(eClassifier.getName())) {
                        tempValue = Integer.valueOf((String)value);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    tempValue = null;
                }
            }
            try {
                if (tempValue != null || this.isEReference(featureParent)) {
                    Object finalValue = tempValue;
                    CellUpdater updater = editedCell.getUpdater();
                    if (updater != null && updater.getDirectEdit() != null) {
                        this.specificSetValue(editedCell, finalValue);
                    } else {
                        this.standardSetValue(line, finalValue);
                    }
                }
            }
            catch (ClassCastException e) {
                SiriusPlugin.getDefault().error(Messages.DFeatureColumnEditingSupport_errorSettingPropertyValue, (Throwable)e);
            }
        }
    }

    private void standardSetValue(DLine line, Object value) {
        Option cell = TableHelper.getCell((DLine)line, (DColumn)this.featureColumn);
        if (cell.some()) {
            this.getEditingDomain().getCommandStack().execute((Command)new StandardSetValueRecordingCommand(this.getEditingDomain(), MessageFormat.format(Messages.Action_setValue, this.getFeatureName()), (DCell)cell.get(), value));
        }
    }

    private void specificSetValue(DCell editedCell, Object value) {
        this.tableEditor.enablePropertiesUpdate(false);
        Command command = this.tableCommandFactory.buildSetCellValueFromTool(editedCell, value);
        if (command.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(command);
        }
        this.tableEditor.enablePropertiesUpdate(true);
        this.tableEditor.forceRefreshProperties();
    }

    private CellEditor getBestCellEditor(final EObject element, boolean directEdit) {
        Object result = null;
        Tree tree = ((TreeViewer)this.getViewer()).getTree();
        final EClassifier eClassifier = this.getEClassifier(element);
        final IItemPropertyDescriptor iItemPropertyDescriptor = this.getPropertyDescriptor(element);
        if (directEdit) {
            boolean isMultiLine = false;
            if (iItemPropertyDescriptor != null) {
                isMultiLine = iItemPropertyDescriptor.isMultiLine((Object)element);
            }
            result = this.getBestCellEditorForDirectEdit(tree, isMultiLine);
        } else if (this.isEReference(element)) {
            final Collection choiceOfValues = iItemPropertyDescriptor.getChoiceOfValues((Object)element);
            if (iItemPropertyDescriptor.isMany((Object)element)) {
                boolean valid = true;
                for (Object choice : choiceOfValues) {
                    if (eClassifier.isInstance(choice)) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    result = new ExtendedDialogCellEditor((Composite)tree, this.getLabelProvider(element)){

                        protected Object openDialogBox(Control cellEditorWindow) {
                            FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), DFeatureColumnEditingSupport.this.getLabelProvider(element), (Object)element, eClassifier, (List)this.doGetValue(), iItemPropertyDescriptor.getDisplayName((Object)element), new ArrayList(choiceOfValues), false, iItemPropertyDescriptor.isSortChoices((Object)element), true);
                            dialog.open();
                            return dialog.getResult();
                        }
                    };
                }
            } else {
                result = new ExtendedComboBoxCellEditor((Composite)tree, new ArrayList(choiceOfValues), this.getLabelProvider(element), iItemPropertyDescriptor.isSortChoices((Object)element));
            }
        } else if (eClassifier != null) {
            if (eClassifier instanceof EDataType && ("Boolean".equals(((EDataType)eClassifier).getName()) || "EBoolean".equals(((EDataType)eClassifier).getName()))) {
                result = new CheckboxCellEditor((Composite)tree);
            } else if (eClassifier instanceof EEnum) {
                Collection choiceOfValues;
                Object genericFeature = iItemPropertyDescriptor.getFeature((Object)element);
                if (genericFeature instanceof EStructuralFeature && (choiceOfValues = iItemPropertyDescriptor.getChoiceOfValues((Object)element)) != null) {
                    result = new ExtendedComboBoxCellEditor((Composite)tree, new ArrayList(choiceOfValues), this.getLabelProvider(element), iItemPropertyDescriptor.isSortChoices((Object)element));
                }
                if (result == null) {
                    result = new ComboBoxCellEditor((Composite)tree, this.getValues((EEnum)eClassifier).toArray(new String[0]), 8);
                }
            } else {
                int style = 4;
                if (iItemPropertyDescriptor != null && iItemPropertyDescriptor.isMultiLine((Object)element)) {
                    style = 66;
                }
                TextCellEditor textEditor = new TextCellEditor((Composite)tree, style){

                    protected void doSetFocus() {
                        super.doSetFocus();
                        if (this.text != null) {
                            this.text.clearSelection();
                        }
                    }
                };
                textEditor.getControl().addFocusListener((FocusListener)new DTableCellEditorFocusListener(this.tableEditor, textEditor));
                result = textEditor;
            }
        }
        return result;
    }

    private CellEditor getBestCellEditorForDirectEdit(Tree tree, boolean isMultiLine) {
        int style = 4;
        if (isMultiLine) {
            style = 66;
        }
        TextCellEditor textEditor = new TextCellEditor((Composite)tree, style){

            protected void doSetValue(Object value) {
                if (value != null) {
                    super.doSetValue(value);
                }
            }

            protected void doSetFocus() {
                super.doSetFocus();
                if (this.text != null) {
                    this.text.clearSelection();
                }
            }
        };
        textEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                if (value == null) {
                    return Messages.DFeatureColumnEditingSupport_notValidValue;
                }
                return null;
            }
        });
        textEditor.getControl().addFocusListener((FocusListener)new DTableCellEditorFocusListener(this.tableEditor, textEditor));
        TextCellEditor result = textEditor;
        return result;
    }

    private List<String> getValues(EEnum enumeration) {
        EList listValues = enumeration.getELiterals();
        ArrayList<String> items = new ArrayList<String>(listValues.size());
        for (EEnumLiteral enumLiteral : listValues) {
            items.add(enumLiteral.getLiteral());
        }
        return items;
    }

    private EClassifier getEClassifier(EObject element) {
        EStructuralFeature eStructuralFeature;
        if (element != null && (eStructuralFeature = element.eClass().getEStructuralFeature(this.getFeatureName())) != null) {
            return eStructuralFeature.getEType();
        }
        return null;
    }

    protected String getFeatureName() {
        return this.featureColumn.getFeatureName();
    }

    private int getIndex(EEnum enumeration, String literal) {
        int result = -1;
        EList listValues = enumeration.getELiterals();
        int i = 0;
        while (i < listValues.size() && result == -1) {
            if (((EEnumLiteral)listValues.get(i)).getLiteral().equals(literal)) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    private IPermissionAuthority getAuthority() {
        return this.getAccessor().getPermissionAuthority();
    }

    private ModelAccessor getAccessor() {
        return this.accessor;
    }

    private boolean isEReference(EObject target) {
        if (target == null) {
            return false;
        }
        EStructuralFeature structuralFeature = target.eClass().getEStructuralFeature(this.getFeatureName());
        return structuralFeature instanceof EReference;
    }

    private boolean isMany(EObject target) {
        EStructuralFeature structuralFeature = target.eClass().getEStructuralFeature(this.getFeatureName());
        return structuralFeature.isMany();
    }

    private ILabelProvider getLabelProvider(EObject instance) {
        final IItemPropertyDescriptor itemPropertyDescriptor = this.getPropertyDescriptor(instance);
        return new LabelProvider(){

            public String getText(Object object) {
                if (itemPropertyDescriptor != null && object != null) {
                    return itemPropertyDescriptor.getLabelProvider(object).getText(object);
                }
                return super.getText(object);
            }

            public Image getImage(Object object) {
                if (itemPropertyDescriptor != null) {
                    return ExtendedImageRegistry.getInstance().getImage(itemPropertyDescriptor.getLabelProvider(object).getImage(object));
                }
                return null;
            }
        };
    }

    private IItemPropertyDescriptor getPropertyDescriptor(EObject instance) {
        if (instance == null) {
            return null;
        }
        EStructuralFeature structuralFeature = instance.eClass().getEStructuralFeature(this.getFeatureName());
        IItemPropertySource propertySource = (IItemPropertySource)this.adapterFactory.adapt((Notifier)instance, IItemPropertySource.class);
        IItemPropertyDescriptor propertyDescriptor = null;
        if (propertySource != null) {
            Iterator iterDescriptors = propertySource.getPropertyDescriptors((Object)instance).iterator();
            while (iterDescriptors.hasNext() && propertyDescriptor == null) {
                IItemPropertyDescriptor currentPropertyDescriptor = (IItemPropertyDescriptor)iterDescriptors.next();
                Object currentFeature = currentPropertyDescriptor.getFeature((Object)instance);
                if (currentFeature == null || !currentFeature.equals(structuralFeature)) continue;
                propertyDescriptor = currentPropertyDescriptor;
            }
        }
        return propertyDescriptor;
    }

    protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        if (((DTableTreeViewer)this.getViewer()).getFirstEditionCharacter() != null) {
            cellEditor.setValue((Object)((DTableTreeViewer)this.getViewer()).getFirstEditionCharacter().toString());
        } else {
            super.initializeCellEditorValue(cellEditor, cell);
        }
    }

    private class StandardSetValueRecordingCommand
    extends RecordingCommand {
        private DCell cell;
        private Object value;

        public StandardSetValueRecordingCommand(TransactionalEditingDomain domain, String label, DCell cell, Object value) {
            super(domain, label);
            this.cell = cell;
            this.value = value;
        }

        protected void doExecute() {
            try {
                if (DFeatureColumnEditingSupport.this.getAccessor().eGet(this.cell.getTarget(), DFeatureColumnEditingSupport.this.getFeatureName()) == null && this.value != null || DFeatureColumnEditingSupport.this.getAccessor().eGet(this.cell.getTarget(), DFeatureColumnEditingSupport.this.getFeatureName()) != null && !DFeatureColumnEditingSupport.this.getAccessor().eGet(this.cell.getTarget(), DFeatureColumnEditingSupport.this.getFeatureName()).equals(this.value)) {
                    if (DFeatureColumnEditingSupport.this.isMany(this.cell.getTarget())) {
                        DFeatureColumnEditingSupport.this.getAccessor().eClear(this.cell.getTarget(), DFeatureColumnEditingSupport.this.getFeatureName());
                    }
                    DFeatureColumnEditingSupport.this.getAccessor().eSet(this.cell.getTarget(), DFeatureColumnEditingSupport.this.getFeatureName(), this.value);
                }
            }
            catch (LockedInstanceException e) {
                SiriusPlugin.getDefault().error(IInterpreterMessages.EVALUATION_ERROR_ON_MODEL_MODIFICATION, (Throwable)e);
            }
            catch (FeatureNotFoundException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)DFeatureColumnEditingSupport.this.featureColumn, (EStructuralFeature)TablePackage.eINSTANCE.getDFeatureColumn_FeatureName(), (Throwable)e);
            }
        }
    }
}

