/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.api.helper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.table.business.api.query.DCellQuery;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.CellUpdater;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.CreateCellTool;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.ElementColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.IntersectionMapping;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableTool;
import org.eclipse.sirius.table.metamodel.table.description.TableVariable;

public final class TableHelper {
    private static final Map<DLine, Map<DColumn, DCell>> CACHE = Maps.newLinkedHashMap();
    private static LineContainer currentlyCached;

    private TableHelper() {
    }

    public static void fillCache(DTable table) {
        TableHelper.fillCacheRec(table);
    }

    private static void fillCacheRec(LineContainer container) {
        for (DLine line : container.getLines()) {
            for (DCell cell : line.getCells()) {
                if (!CACHE.containsKey(line)) {
                    CACHE.put(line, Maps.newLinkedHashMap());
                }
                CACHE.get(line).put(cell.getColumn(), cell);
            }
            TableHelper.fillCacheRec(line);
        }
        currentlyCached = container;
    }

    public static void clearCache() {
        CACHE.clear();
        currentlyCached = null;
    }

    public static boolean hasSemanticCandidatesExpression(LineMapping mapping) {
        return !StringUtil.isEmpty((String)mapping.getSemanticCandidatesExpression());
    }

    public static boolean hasSemanticCandidatesExpression(ElementColumnMapping mapping) {
        return !StringUtil.isEmpty((String)mapping.getSemanticCandidatesExpression());
    }

    public static DTable getTable(EObject element) {
        EObject container = element;
        while (container != null) {
            if (container instanceof DTable) {
                return (DTable)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    public static Option<DCell> getCell(DLine line, DColumn column) {
        DCell found = null;
        if (currentlyCached == TableHelper.getTable((EObject)line) && CACHE.containsKey(line)) {
            found = CACHE.get(line).get(column);
        } else {
            Iterator it = line.getCells().iterator();
            while (it.hasNext() && found == null) {
                DCell next = (DCell)it.next();
                if (next.getColumn() != column) continue;
                found = next;
            }
        }
        if (found != null) {
            return Options.newSome((Object)found);
        }
        return Options.newNone();
    }

    public static DCell getCell(DTable table, int lineIndex, int columnIndex) {
        DColumn column;
        DLine line;
        Option<DCell> optionalCell;
        DCell result = null;
        if (table.getLines().size() > lineIndex && table.getColumns().size() > columnIndex && (optionalCell = TableHelper.getCell(line = (DLine)table.getLines().get(lineIndex), column = (DColumn)table.getColumns().get(columnIndex))).some()) {
            result = (DCell)optionalCell.get();
        }
        return result;
    }

    public static EClassifier getEClassifier(DLine line, DColumn column) {
        EStructuralFeature structuralFeature;
        Option<DCell> cellOption;
        if (column instanceof DFeatureColumn && (cellOption = TableHelper.getCell(line, column)).some() && ((DCell)cellOption.get()).getTarget() != null && (structuralFeature = ((DCell)cellOption.get()).getTarget().eClass().getEStructuralFeature(((DFeatureColumn)column).getFeatureName())) != null) {
            return structuralFeature.getEType();
        }
        return null;
    }

    public static List<DLine> getExpandedLines(DTable table) {
        ArrayList<DLine> result = new ArrayList<DLine>();
        EList lines = table.getLines();
        for (DLine line : lines) {
            if (!line.isCollapsed()) {
                result.add(line);
            }
            result.addAll(TableHelper.getExpandedLines(line));
        }
        return result;
    }

    public static List<DLine> getExpandedLines(DLine parentLine) {
        ArrayList<DLine> result = new ArrayList<DLine>();
        EList<DLine> lines = parentLine.getLines();
        for (DLine line : lines) {
            if (!line.isCollapsed()) {
                result.add(line);
            }
            result.addAll(TableHelper.getExpandedLines(line));
        }
        return result;
    }

    public static TableVariable getVariable(TableTool tool, String name) {
        for (TableVariable tableVariable : tool.getVariables()) {
            if (name == null || !name.equals(tableVariable.getName())) continue;
            return tableVariable;
        }
        return null;
    }

    public static boolean canEditCrossTableCell(DCell cell) {
        boolean canEdit = false;
        CellUpdater updater = cell.getUpdater();
        if (updater != null && updater.getDirectEdit() != null) {
            canEdit = true;
        }
        return canEdit;
    }

    public static boolean canEditCrossTableCell(DLine dLine, DTargetColumn dTargetColumn) {
        Option<DCell> optionnalCell = TableHelper.getCell(dLine, dTargetColumn);
        boolean canEdit = false;
        if (optionnalCell.some()) {
            canEdit = TableHelper.canEditCrossTableCell((DCell)optionnalCell.get());
        } else if (TableHelper.canCreate(dLine, dTargetColumn)) {
            canEdit = true;
        }
        return canEdit;
    }

    private static boolean canCreate(DLine line, DTargetColumn column) {
        return TableHelper.getCreateCellTool(line, column) != null;
    }

    public static Option<CreateCellTool> getCreateCellTool(DLine line, DColumn column) {
        DTable table = TableHelper.getTable((EObject)line);
        if (table.getDescription() instanceof CrossTableDescription) {
            ColumnMapping columnMapping = column.getOriginMapping();
            LineMapping lineMapping = line.getOriginMapping();
            for (IntersectionMapping intersectionMapping : ((CrossTableDescription)table.getDescription()).getIntersection()) {
                if (intersectionMapping.getCreate() == null || !columnMapping.equals(intersectionMapping.getColumnMapping()) || intersectionMapping.getLineMapping() == null || !intersectionMapping.getLineMapping().contains((Object)lineMapping)) continue;
                return Options.newSome((Object)intersectionMapping.getCreate());
            }
        }
        return Options.newNone();
    }

    public static boolean hasTableDescriptionOnlyOneLineMapping(DTableElement tableElement) {
        DTable table = TableHelper.getTable((EObject)tableElement);
        if (table != null) {
            return TableHelper.hasTableDescriptionOnlyOneLineMapping(table.getDescription());
        }
        return false;
    }

    public static boolean hasTableDescriptionOnlyOneLineMapping(TableMapping mapping) {
        return TableHelper.hasTableDescriptionOnlyOneLineMapping(TableHelper.getTableDescription(mapping));
    }

    private static boolean hasTableDescriptionOnlyOneLineMapping(TableDescription tableDescription) {
        int nbMappings;
        if (tableDescription != null && (nbMappings = tableDescription.getOwnedLineMappings().size() + tableDescription.getReusedLineMappings().size()) <= 1) {
            for (LineMapping lineMapping : tableDescription.getAllLineMappings()) {
                if ((nbMappings += lineMapping.getAllSubLines().size()) > 1) break;
            }
            return nbMappings == 1;
        }
        return false;
    }

    public static TableDescription getTableDescription(TableMapping mapping) {
        EObject container = mapping.eContainer();
        while (container != null) {
            if (container instanceof TableDescription) {
                return (TableDescription)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    public static Option<DTableElementStyle> getBackgroundStyleToApply(DLine line, DColumn column) {
        DTableElementStyle styleToApply = null;
        DTableElementStyle currentLineStyle = null;
        if (line != null && (currentLineStyle = line.getCurrentStyle()) != null && !currentLineStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_BackgroundColor())) {
            currentLineStyle = null;
        }
        DTableElementStyle currentColumnStyle = null;
        if (column != null && (currentColumnStyle = column.getCurrentStyle()) != null && !currentColumnStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_BackgroundColor())) {
            currentColumnStyle = null;
        }
        if (currentLineStyle != null) {
            styleToApply = !currentLineStyle.isDefaultBackgroundStyle() ? currentLineStyle : (currentColumnStyle != null && !currentColumnStyle.isDefaultBackgroundStyle() ? currentColumnStyle : currentLineStyle);
        } else if (currentColumnStyle != null) {
            styleToApply = currentColumnStyle;
        }
        if (styleToApply == null) {
            return Options.newSome((Object)DCellQuery.DEFAULT_STYLE);
        }
        return Options.newSome((Object)styleToApply);
    }

    public static Option<DTableElementStyle> getForegroundStyleToApply(DLine line, DColumn column) {
        DTableElementStyle styleToApply = null;
        DTableElementStyle currentLineStyle = null;
        if (!(line == null || (currentLineStyle = line.getCurrentStyle()) == null || currentLineStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_ForegroundColor()) || currentLineStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelFormat()) || currentLineStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelSize()))) {
            currentLineStyle = null;
        }
        DTableElementStyle currentColumnStyle = null;
        if (!(column == null || (currentColumnStyle = column.getCurrentStyle()) == null || currentColumnStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_ForegroundColor()) || currentColumnStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelFormat()) || currentColumnStyle.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelSize()))) {
            currentColumnStyle = null;
        }
        if (currentLineStyle != null) {
            styleToApply = !currentLineStyle.isDefaultForegroundStyle() ? currentLineStyle : (currentColumnStyle != null && !currentColumnStyle.isDefaultForegroundStyle() ? currentColumnStyle : currentLineStyle);
        } else if (currentColumnStyle != null) {
            styleToApply = currentColumnStyle;
        }
        if (styleToApply == null) {
            return Options.newNone();
        }
        return Options.newSome((Object)styleToApply);
    }
}

