/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.commands;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.metamodel.helper.ComponentizationHelper;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;

public class ChangeViewpointSelectionCommand
extends RecordingCommand {
    private Session session;
    private final ViewpointSelection.Callback callback;
    private final Set<Viewpoint> newSelectedViewpoints;
    private final Set<Viewpoint> newDeselectedViewpoints;
    private boolean createNewRepresentations;
    private IProgressMonitor monitor;

    public ChangeViewpointSelectionCommand(Session session, ViewpointSelection.Callback callback, Set<Viewpoint> newSelectedViewpoints, Set<Viewpoint> newDeselectedViewpoints, IProgressMonitor monitor) {
        super(session.getTransactionalEditingDomain(), Messages.ChangeViewpointSelectionCommand_label);
        this.callback = callback;
        this.newSelectedViewpoints = newSelectedViewpoints;
        this.newDeselectedViewpoints = newDeselectedViewpoints;
        this.session = session;
        this.monitor = monitor;
        this.createNewRepresentations = true;
    }

    public ChangeViewpointSelectionCommand(Session session, ViewpointSelection.Callback callback, Set<Viewpoint> newSelectedViewpoints, Set<Viewpoint> newDeselectedViewpoints, boolean createNewRepresentations, IProgressMonitor monitor) {
        this(session, callback, newSelectedViewpoints, newDeselectedViewpoints, monitor);
        this.createNewRepresentations = createNewRepresentations;
    }

    protected void doExecute() {
        if (this.callback == null || this.session == null) {
            return;
        }
        try {
            int nbViewpointsInChange = (this.newSelectedViewpoints != null ? this.newSelectedViewpoints.size() + 1 : 0) + (this.newDeselectedViewpoints != null ? this.newDeselectedViewpoints.size() : 0);
            this.monitor.beginTask(Messages.ChangeViewpointSelectionCommand_applySelectionTask, nbViewpointsInChange);
            if (this.newSelectedViewpoints != null) {
                List<Viewpoint> sorted = this.sortByDependencies(this.newSelectedViewpoints);
                this.monitor.worked(1);
                for (Viewpoint viewpoint : sorted) {
                    this.monitor.subTask(MessageFormat.format(Messages.ChangeViewpointSelectionCommand_selectViewpointTask, new IdentifiedElementQuery((IdentifiedElement)viewpoint).getLabel()));
                    try {
                        this.callback.selectViewpoint(viewpoint, this.session, this.createNewRepresentations, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
                    }
                    catch (SecurityException e) {
                        String errorMessage = MessageFormat.format(Messages.ChangeViewpointSelectionCommand_activationError, viewpoint.getName());
                        throw new SecurityException(errorMessage, e);
                    }
                }
            }
            if (this.newDeselectedViewpoints != null) {
                for (Viewpoint viewpoint : this.newDeselectedViewpoints) {
                    this.monitor.subTask(MessageFormat.format(Messages.ChangeViewpointSelectionCommand_deselectViewpointTask, new IdentifiedElementQuery((IdentifiedElement)viewpoint).getLabel()));
                    this.callback.deselectViewpoint(viewpoint, this.session, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
                }
            }
        }
        finally {
            this.monitor.done();
        }
    }

    private List<Viewpoint> sortByDependencies(Collection<Viewpoint> viewpoints) {
        ArrayList<Viewpoint> orderedViewpoints = new ArrayList<Viewpoint>(viewpoints.size());
        for (Viewpoint viewpoint : viewpoints) {
            int insertPosition = orderedViewpoints.size();
            for (Viewpoint viewpoint2 : orderedViewpoints) {
                if (ComponentizationHelper.isExtendedBy((Viewpoint)viewpoint, (Viewpoint)viewpoint2)) {
                    insertPosition = orderedViewpoints.indexOf(viewpoint2);
                    continue;
                }
                if (!ComponentizationHelper.isExtendedBy((Viewpoint)viewpoint2, (Viewpoint)viewpoint)) continue;
                insertPosition = orderedViewpoints.indexOf(viewpoint2) + 1;
            }
            orderedViewpoints.add(insertPosition, viewpoint);
        }
        Collections.reverse(orderedViewpoints);
        return Collections.unmodifiableList(orderedViewpoints);
    }
}

