/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.color;

import com.google.common.base.Objects;
import java.awt.GradientPaint;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.ext.base.cache.LRUCache;
import org.eclipse.sirius.ext.swt.SWTResourceLRUCache;
import org.eclipse.sirius.tools.api.ui.color.EnvironmentSystemColorFactory;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.FixedColor;
import org.eclipse.sirius.viewpoint.description.SystemColor;
import org.eclipse.sirius.viewpoint.description.SystemColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;

public class VisualBindingManager {
    private static final String DEFAULT_FONT_NAME = "ARIAL";
    private static VisualBindingManager defaultInstance;
    private final Map<String, RGB> systemPalette;
    private Map<String, Color> colorCache;
    private Map<FontStyleDescriptor, Font> fontCache;
    private Map<Integer, Font> intToFontCache;
    private Map<PatternDescriptor, Pattern> patternCache;
    private Map<PatternDescriptor, GradientPaint> gradientPaintCache;

    public VisualBindingManager() {
        HashMap<String, RGB> palette = new HashMap<String, RGB>(SystemColors.values().length);
        this.addStandardPaletteColors(palette);
        this.systemPalette = palette;
    }

    public Map<String, RGB> getSystemPalette() {
        return this.systemPalette;
    }

    public static VisualBindingManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new VisualBindingManager();
        }
        return defaultInstance;
    }

    public void init(int colorCacheSize, int fontCacheSize) {
        this.colorCache = new SWTResourceLRUCache(colorCacheSize, colorCacheSize);
        this.fontCache = new SWTResourceLRUCache(fontCacheSize, fontCacheSize);
        this.intToFontCache = new SWTResourceLRUCache(fontCacheSize, fontCacheSize);
        this.patternCache = new SWTResourceLRUCache(colorCacheSize, colorCacheSize);
        this.gradientPaintCache = new LRUCache(colorCacheSize, colorCacheSize);
    }

    public void dispose() {
        this.systemPalette.clear();
        VisualBindingManager.disposeResources(this.colorCache.values());
        this.colorCache.clear();
        VisualBindingManager.disposeResources(this.fontCache.values());
        this.fontCache.clear();
        VisualBindingManager.disposeResources(this.intToFontCache.values());
        this.intToFontCache.clear();
        VisualBindingManager.disposeResources(this.patternCache.values());
        this.patternCache.clear();
        this.gradientPaintCache.clear();
    }

    private static <T extends Resource> void disposeResources(Collection<T> resources) {
        for (Resource resource : resources) {
            resource.dispose();
        }
    }

    private void addStandardPaletteColors(Map<String, RGB> palette) {
        palette.put(SystemColors.WHITE_LITERAL.getName(), new RGB(255, 255, 255));
        palette.put(SystemColors.BLACK_LITERAL.getName(), new RGB(0, 0, 0));
        palette.put(SystemColors.BLUE_LITERAL.getName(), new RGB(114, 159, 207));
        palette.put(SystemColors.CHOCOLATE_LITERAL.getName(), new RGB(233, 185, 110));
        palette.put(SystemColors.GRAY_LITERAL.getName(), new RGB(136, 136, 136));
        palette.put(SystemColors.GREEN_LITERAL.getName(), new RGB(138, 226, 52));
        palette.put(SystemColors.ORANGE_LITERAL.getName(), new RGB(252, 175, 62));
        palette.put(SystemColors.PURPLE_LITERAL.getName(), new RGB(173, 127, 168));
        palette.put(SystemColors.RED_LITERAL.getName(), new RGB(239, 41, 41));
        palette.put(SystemColors.YELLOW_LITERAL.getName(), new RGB(252, 233, 79));
        palette.put(SystemColors.LIGHT_BLUE_LITERAL.getName(), new RGB(194, 239, 255));
        palette.put(SystemColors.LIGHT_CHOCOLATE_LITERAL.getName(), new RGB(238, 201, 142));
        palette.put(SystemColors.LIGHT_GRAY_LITERAL.getName(), new RGB(209, 209, 209));
        palette.put(SystemColors.LIGHT_GREEN_LITERAL.getName(), new RGB(204, 242, 166));
        palette.put(SystemColors.LIGHT_ORANGE_LITERAL.getName(), new RGB(253, 206, 137));
        palette.put(SystemColors.LIGHT_PURPLE_LITERAL.getName(), new RGB(217, 196, 215));
        palette.put(SystemColors.LIGHT_RED_LITERAL.getName(), new RGB(246, 139, 139));
        palette.put(SystemColors.LIGHT_YELLOW_LITERAL.getName(), new RGB(255, 245, 181));
        palette.put(SystemColors.DARK_BLUE_LITERAL.getName(), new RGB(39, 76, 114));
        palette.put(SystemColors.DARK_CHOCOLATE_LITERAL.getName(), new RGB(154, 103, 23));
        palette.put(SystemColors.DARK_GRAY_LITERAL.getName(), new RGB(69, 69, 69));
        palette.put(SystemColors.DARK_GREEN_LITERAL.getName(), new RGB(77, 137, 20));
        palette.put(SystemColors.DARK_ORANGE_LITERAL.getName(), new RGB(224, 133, 3));
        palette.put(SystemColors.DARK_PURPLE_LITERAL.getName(), new RGB(114, 73, 110));
        palette.put(SystemColors.DARK_RED_LITERAL.getName(), new RGB(156, 12, 12));
        palette.put(SystemColors.DARK_YELLOW_LITERAL.getName(), new RGB(214, 197, 66));
    }

    private RGB getDescriptorFromName(String name) {
        if (this.systemPalette.containsKey(name)) {
            return this.systemPalette.get(name);
        }
        return this.systemPalette.get(DescriptionPackage.eINSTANCE.getSystemColors().getDefaultValue());
    }

    public RGBValues getRGBValuesFor(SystemColors defaultColor) {
        RGB rgb = this.systemPalette.get(defaultColor.getName());
        return this.createRGBvalues(rgb);
    }

    public Color getColorFromValue(int value, int max) {
        return this.getColorFromCache(this.getColorCodeValue(value, max, 0));
    }

    public Color getColorFromName(String name) {
        return this.getColorFromCache(this.getDescriptorFromName(name));
    }

    public Color getColorFromRGB(RGB rgb) {
        return this.getColorFromCache(rgb);
    }

    public Color getColorFromRGBValues(RGBValues values) {
        if (values != null) {
            return this.getColorFromRGBValue(values.getRed(), values.getGreen(), values.getBlue());
        }
        return this.getColorFromName(SystemColors.GRAY_LITERAL.getName());
    }

    public Color getLabelColorFromRGBValues(RGBValues values) {
        if (values != null) {
            return this.getColorFromRGBValue(values.getRed(), values.getGreen(), values.getBlue());
        }
        return this.getColorFromName("black");
    }

    private Color getColorFromCache(RGB rgb) {
        String key = rgb.toString();
        if (!this.colorCache.containsKey(key)) {
            this.colorCache.put(key, this.createColor(rgb));
        }
        return this.colorCache.get(key);
    }

    private Color createColor(RGB rgb) {
        return new Color((Device)Display.getDefault(), rgb);
    }

    public RGBValues createRGBvalues(RGB rgb) {
        RGBValues result = RGBValues.create((int)rgb.red, (int)rgb.green, (int)rgb.blue);
        return result;
    }

    public SystemColors getDColorFromRGBColor(FixedColor color) {
        return this.findClosestSystemColor(color);
    }

    public Color getColorFromRGBValue(int red, int green, int blue) {
        return this.getColorFromCache(new RGB(VisualBindingManager.clamp(red, 0, 255), VisualBindingManager.clamp(green, 0, 255), VisualBindingManager.clamp(blue, 0, 255)));
    }

    public static int clamp(int value, int min, int max) {
        return EnvironmentSystemColorFactory.clamp((int)value, (int)min, (int)max);
    }

    public Color getColorFromValue(int value) {
        return this.getColorFromValue(value, 100);
    }

    public int getLineWidthFromValue(int value, int max) {
        return (int)((double)value * 10.0 / (double)max);
    }

    public int getLineWidthFromValue(int value) {
        return this.getLineWidthFromValue(value, 10);
    }

    public RGB getColorCodeValue(int pvalue, int pmax, int pmin) {
        int min = pmin;
        int max = pmax;
        int value = pvalue;
        Color red = this.getColorFromName("red");
        Color green = this.getColorFromName("green");
        if (max <= min) {
            max = min + 1;
        }
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        float scale = ((float)value - (float)min) / (float)(max - min);
        int valRed = (int)((float)green.getRed() + (float)(red.getRed() - green.getRed()) * scale);
        int valGreen = (int)((float)green.getGreen() + (float)(red.getGreen() - green.getGreen()) * scale);
        int valBlue = (int)((float)green.getBlue() + (float)(red.getBlue() - green.getBlue()) * scale);
        return new RGB(VisualBindingManager.clamp(valRed, 0, 255), VisualBindingManager.clamp(valGreen, 0, 255), VisualBindingManager.clamp(valBlue, 0, 255));
    }

    public Color getColorFromValue(int value, int max, int min) {
        return this.getColorFromCache(this.getColorCodeValue(value, max, min));
    }

    public SystemColors findClosestSystemColor(FixedColor color) {
        int bestDistanceSoFar = Integer.MAX_VALUE;
        String bestColorNameSoFar = null;
        for (Map.Entry<String, RGB> defaultColorName : this.systemPalette.entrySet()) {
            int dist = this.squareDistance(defaultColorName.getValue(), color);
            if (dist >= bestDistanceSoFar) continue;
            bestColorNameSoFar = defaultColorName.getKey();
            bestDistanceSoFar = dist;
            if (dist == 0) break;
        }
        return SystemColors.getByName(bestColorNameSoFar);
    }

    public SystemColors findClosestStandardColor(RGBValues values) {
        SystemColor color = DescriptionFactory.eINSTANCE.createSystemColor();
        color.setName("<anonymous>");
        color.setRed(values.getRed());
        color.setGreen(values.getGreen());
        color.setBlue(values.getBlue());
        return this.findClosestSystemColor((FixedColor)color);
    }

    private int squareDistance(RGB rgb, FixedColor color) {
        return this.squareDistance(rgb.red, rgb.green, rgb.blue, color.getRed(), color.getGreen(), color.getBlue());
    }

    private int squareDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        return dx * dx + dy * dy + dz * dz;
    }

    private Pattern getPatternFromCache(PatternDescriptor desc) {
        if (!this.patternCache.containsKey(desc)) {
            this.patternCache.put(desc, desc.createPattern());
        }
        return this.patternCache.get(desc);
    }

    private GradientPaint getGradientPaintFromCache(PatternDescriptor desc) {
        if (!this.gradientPaintCache.containsKey(desc)) {
            this.gradientPaintCache.put(desc, desc.createGradientPaint());
        }
        return this.gradientPaintCache.get(desc);
    }

    public Pattern getPatternFromValue(int x, int y, int w, int h, Color backgroundColor, Color foregrounColor) {
        PatternDescriptor desc = new PatternDescriptor(x, y, w, h, backgroundColor, foregrounColor);
        return this.getPatternFromCache(desc);
    }

    public GradientPaint getGradientPaintFromValue(int x, int y, int w, int h, Color backgroundColor, Color foregrounColor) {
        PatternDescriptor desc = new PatternDescriptor(x, y, w, h, backgroundColor, foregrounColor);
        return this.getGradientPaintFromCache(desc);
    }

    public Font getFontFromValue(int size) {
        int rangedSize = Math.max(size, 1);
        if (!this.intToFontCache.containsKey(rangedSize)) {
            this.intToFontCache.put(rangedSize, new Font((Device)Display.getDefault(), DEFAULT_FONT_NAME, rangedSize, 0));
        }
        return this.intToFontCache.get(rangedSize);
    }

    public Font getFontFromLabelStyle(BasicLabelStyle style) {
        return this.getFontFromLabelFormatAndSize((List<FontFormat>)style.getLabelFormat(), style.getLabelSize(), DEFAULT_FONT_NAME);
    }

    public Font getFontFromLabelStyle(BasicLabelStyle style, String fontName) {
        if (fontName == null) {
            return this.getFontFromLabelStyle(style);
        }
        return this.getFontFromLabelFormatAndSize((List<FontFormat>)style.getLabelFormat(), style.getLabelSize(), fontName);
    }

    public boolean isUnderlineFromLabelStyle(BasicLabelStyle style) {
        EList labelFormat = style.getLabelFormat();
        for (FontFormat fontFormat : labelFormat) {
            if (FontFormat.UNDERLINE_LITERAL != fontFormat) continue;
            return true;
        }
        return false;
    }

    public boolean isStrikeThroughFromLabelStyle(BasicLabelStyle style) {
        EList labelFormat = style.getLabelFormat();
        for (FontFormat fontFormat : labelFormat) {
            if (FontFormat.STRIKE_THROUGH_LITERAL != fontFormat) continue;
            return true;
        }
        return false;
    }

    public Font getFontFromLabelFormatAndSize(List<FontFormat> labelFormat, int labelSize) {
        return this.getFontFromLabelFormatAndSize(labelFormat, labelSize, DEFAULT_FONT_NAME);
    }

    public Font getFontFromLabelFormatAndSize(List<FontFormat> labelFormat, int labelSize, String fontName) {
        int rangedSize = Math.max(labelSize, 1);
        FontStyleDescriptor desc = new FontStyleDescriptor(labelFormat, rangedSize, fontName);
        if (!this.fontCache.containsKey(desc)) {
            int format = 0;
            for (FontFormat fontFormat : labelFormat) {
                if (FontFormat.BOLD_LITERAL.equals((Object)fontFormat)) {
                    format |= 1;
                }
                if (!FontFormat.ITALIC_LITERAL.equals((Object)fontFormat)) continue;
                format |= 2;
            }
            this.fontCache.put(desc, new Font((Device)Display.getDefault(), fontName, rangedSize, format));
        }
        return this.fontCache.get(desc);
    }

    public SystemColor getSystemColorDescription(String name) {
        String uri = "environment:/viewpoint#/0/@systemColors/@entries[name='" + name + "']";
        EObject color = EcoreUtil.create((EClass)DescriptionPackage.eINSTANCE.getSystemColor());
        URI colorURI = URI.createURI((String)uri);
        ((InternalEObject)color).eSetProxyURI(colorURI);
        return (SystemColor)color;
    }

    private static final class FontStyleDescriptor {
        final String name;
        final Set<FontFormat> format;
        final int size;

        public FontStyleDescriptor(List<FontFormat> format, int size, String name) {
            this.format = format.isEmpty() ? null : EnumSet.copyOf(format);
            this.size = size;
            this.name = name;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.format, this.size});
        }

        public boolean equals(Object obj) {
            boolean result;
            if (this == obj) {
                result = true;
            } else if (obj instanceof FontStyleDescriptor) {
                FontStyleDescriptor that = (FontStyleDescriptor)obj;
                result = Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.format, that.format) && this.size == that.size;
            } else {
                result = false;
            }
            return result;
        }
    }

    private static final class PatternDescriptor {
        final int x;
        final int y;
        final int w;
        final int h;
        final Color backgroundColor;
        final Color foregroundColor;

        public PatternDescriptor(int x, int y, int w, int h, Color backgroundColor, Color foregrounColor) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.backgroundColor = backgroundColor;
            this.foregroundColor = foregrounColor;
        }

        public boolean equals(Object obj) {
            boolean result;
            if (this == obj) {
                result = true;
            } else if (obj instanceof PatternDescriptor) {
                PatternDescriptor that = (PatternDescriptor)obj;
                boolean sameCoordinates = this.x == that.x && this.y == that.y && this.h == that.h && this.w == that.w;
                result = sameCoordinates && Objects.equal((Object)this.backgroundColor, (Object)that.backgroundColor) && Objects.equal((Object)this.foregroundColor, (Object)that.foregroundColor);
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.x, this.y, this.w, this.h, this.foregroundColor, this.backgroundColor});
        }

        public Pattern createPattern() {
            return new Pattern(null, (float)this.x, (float)this.y, (float)(this.x + this.w), (float)(this.y + this.h), this.backgroundColor, this.foregroundColor);
        }

        public GradientPaint createGradientPaint() {
            return new GradientPaint(this.x, this.y, new java.awt.Color(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue()), this.x + this.w, this.y + this.h, new java.awt.Color(this.foregroundColor.getRed(), this.foregroundColor.getGreen(), this.foregroundColor.getBlue()));
        }
    }
}

