/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource.strategy;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.internal.resource.strategy.DefaultOptimizedResourceStrategyImpl;
import org.eclipse.sirius.business.internal.resource.strategy.ResourceStrategy;
import org.eclipse.sirius.viewpoint.Messages;

public class DefaultResourceStrategyImpl
extends DefaultOptimizedResourceStrategyImpl
implements ResourceStrategy {
    @Override
    public IStatus releaseResourceAtResourceSetDispose(Resource resource, IProgressMonitor monitor) {
        try {
            if (!this.isFromPackageRegistry(resource)) {
                resource.unload();
            }
        }
        catch (IllegalStateException e) {
            return new Status(2, "org.eclipse.sirius", MessageFormat.format(Messages.DAnalysisSessionImpl_unloadingErrorMsg, e.getMessage()), (Throwable)e);
        }
        return new Status(0, "org.eclipse.sirius", "");
    }

    private boolean isFromPackageRegistry(Resource resource) {
        URI uri = resource.getURI();
        return uri != null && resource.getResourceSet().getPackageRegistry().getEPackage(uri.toString()) != null;
    }

    @Override
    public boolean canHandle(Resource resource, ResourceStrategy.ResourceStrategyType resourceStrategyType) {
        return true;
    }

    @Override
    public boolean canHandle(URI resourceURI, ResourceStrategy.ResourceStrategyType resourceStrategyType) {
        return true;
    }
}

