/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.util.LazyCrossReferencer;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class SessionLazyCrossReferencer
extends LazyCrossReferencer {
    private DAnalysisSessionImpl session;

    public SessionLazyCrossReferencer(DAnalysisSessionImpl session) {
        this.session = session;
    }

    protected void initialize() {
        super.initialize();
        Collection<Resource> semanticResources = this.session.getSemanticResources();
        EList<Resource> controlledResources = this.session.getControlledResources();
        Set<Resource> allSessionResources = this.session.getAllSessionResources();
        Iterable resources = Iterables.concat(semanticResources, controlledResources, allSessionResources);
        for (Resource resource : resources) {
            EList adapters = resource.eAdapters();
            if (adapters.contains((Object)this)) continue;
            adapters.add(this);
        }
    }

    protected void selfAdapt(Notification notification) {
        if (SessionLazyCrossReferencer.isTopLevelRepresentationRemoval(notification) && !this.unloadedResources.contains(notification.getNotifier())) {
            this.handleContainment(notification);
        }
        super.selfAdapt(notification);
    }

    public static boolean isTopLevelRepresentationRemoval(Notification notification) {
        boolean isRepresentationRemoval;
        boolean isResourceContentChange;
        Object notifier = notification.getNotifier();
        boolean bl = isResourceContentChange = notifier instanceof Resource && notification.getFeatureID(Resource.class) == 2;
        if (notification.getEventType() == 4 && notification.getOldValue() instanceof DRepresentation) {
            isRepresentationRemoval = true;
        } else if (notification.getEventType() == 6) {
            Collection removed = (Collection)notification.getOldValue();
            isRepresentationRemoval = Iterables.all((Iterable)removed, (Predicate)Predicates.instanceOf(DRepresentation.class));
        } else {
            isRepresentationRemoval = false;
        }
        return isResourceContentChange && isRepresentationRemoval;
    }
}

