/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.ui.action;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.GeneratorUIUtil;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateAllAction
implements IExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> selections) {
        return true;
    }

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        Object genmodelsParamValue = parameters.get("genmodels");
        String scope = (String)parameters.get("scope");
        if (scope == null) {
            scope = "model, edit, editor, tests";
        }
        if (genmodelsParamValue != null && genmodelsParamValue instanceof Collection) {
            this.launchEMFGeneration(genmodelsParamValue, scope);
        }
    }

    private void launchEMFGeneration(Object genmodelsParamValue, final String scope) {
        final ArrayList gens = Lists.newArrayList((Iterable)Iterables.filter((Iterable)((Collection)genmodelsParamValue), GenModel.class));
        if (gens.size() > 0) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    IEditorPart activeEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                    GeneratorUIUtil.GeneratorOperation operation = new GeneratorUIUtil.GeneratorOperation(activeEditorPart.getSite().getShell());
                    for (GenModel genModel : gens) {
                        genModel.reconcile();
                        genModel.setCanGenerate(true);
                        Generator generator = new Generator();
                        generator.setInput((Object)genModel);
                        if (scope.contains("model")) {
                            operation.addGeneratorAndArguments(generator, (Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_ModelProject_name"));
                        }
                        if (scope.contains("edit")) {
                            operation.addGeneratorAndArguments(generator, (Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_EditProject_name"));
                        }
                        if (scope.contains("editor")) {
                            operation.addGeneratorAndArguments(generator, (Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_EditorProject_name"));
                        }
                        if (!scope.contains("tests")) continue;
                        operation.addGeneratorAndArguments(generator, (Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_TestsProject_name"));
                    }
                    try {
                        IWorkbench wb = PlatformUI.getWorkbench();
                        IProgressService ps = wb.getProgressService();
                        ps.busyCursorWhile((IRunnableWithProgress)operation);
                    }
                    catch (Exception exception) {
                        GenModelEditPlugin.INSTANCE.log((Object)exception);
                    }
                }
            });
        }
    }
}

