/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.IOException;
import java.io.InputStream;

public class Base64DecodeStream
extends InputStream {
    InputStream src;
    private static final byte[] pem_array = new byte[256];
    byte[] decode_buffer = new byte[4];
    byte[] out_buffer = new byte[3];
    int out_offset = 3;
    boolean EOF = false;

    public Base64DecodeStream(InputStream inputStream) {
        this.src = inputStream;
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        this.EOF = true;
    }

    public int available() throws IOException {
        return 3 - this.out_offset;
    }

    public int read() throws IOException {
        if (this.out_offset == 3 && (this.EOF || this.getNextAtom())) {
            this.EOF = true;
            return -1;
        }
        return this.out_buffer[this.out_offset++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            if (this.out_offset == 3 && (this.EOF || this.getNextAtom())) {
                this.EOF = true;
                if (n3 == 0) {
                    return -1;
                }
                return n3;
            }
            byArray[n + n3] = this.out_buffer[this.out_offset++];
            ++n3;
        }
        return n3;
    }

    final boolean getNextAtom() throws IOException {
        int n = 0;
        while (n != 4) {
            int n2 = this.src.read(this.decode_buffer, n, 4 - n);
            if (n2 == -1) {
                return true;
            }
            int n3 = n;
            int n4 = n;
            while (n3 < n + n2) {
                if (this.decode_buffer[n3] != 10 && this.decode_buffer[n3] != 13 && this.decode_buffer[n3] != 32) {
                    this.decode_buffer[n4++] = this.decode_buffer[n3];
                }
                ++n3;
            }
            n = n4;
        }
        byte by = pem_array[this.decode_buffer[0] & 0xFF];
        byte by2 = pem_array[this.decode_buffer[1] & 0xFF];
        byte by3 = pem_array[this.decode_buffer[2] & 0xFF];
        byte by4 = pem_array[this.decode_buffer[3] & 0xFF];
        this.out_buffer[0] = (byte)(by << 2 | by2 >>> 4);
        this.out_buffer[1] = (byte)(by2 << 4 | by3 >>> 2);
        this.out_buffer[2] = (byte)(by3 << 6 | by4);
        if (this.decode_buffer[3] != 61) {
            this.out_offset = 0;
        } else if (this.decode_buffer[2] == 61) {
            this.out_buffer[2] = this.out_buffer[0];
            this.out_offset = 2;
            this.EOF = true;
        } else {
            this.out_buffer[2] = this.out_buffer[1];
            this.out_buffer[1] = this.out_buffer[0];
            this.out_offset = 1;
            this.EOF = true;
        }
        return false;
    }

    static {
        int n = 0;
        while (n < pem_array.length) {
            Base64DecodeStream.pem_array[n] = -1;
            ++n;
        }
        int n2 = 0;
        int n3 = 65;
        while (n3 <= 90) {
            Base64DecodeStream.pem_array[n3] = (byte)n2++;
            n3 = (char)(n3 + 1);
        }
        int n4 = 97;
        while (n4 <= 122) {
            Base64DecodeStream.pem_array[n4] = (byte)n2++;
            n4 = (char)(n4 + 1);
        }
        int n5 = 48;
        while (n5 <= 57) {
            Base64DecodeStream.pem_array[n5] = (byte)n2++;
            n5 = (char)(n5 + 1);
        }
        Base64DecodeStream.pem_array[43] = (byte)n2++;
        Base64DecodeStream.pem_array[47] = (byte)n2++;
    }
}

