/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.TargetPlatformHelper;

public class BundleValidationOperation
implements IWorkspaceRunnable {
    private static StateObjectFactory FACTORY;
    private IPluginModelBase[] fModels;
    private Dictionary<?, ?>[] fProperties;
    private State fState;

    public BundleValidationOperation(IPluginModelBase[] models) {
        this(models, new Dictionary[]{TargetPlatformHelper.getTargetEnvironment()});
    }

    public BundleValidationOperation(IPluginModelBase[] models, Dictionary<?, ?>[] properties) {
        this.fModels = models;
        this.fProperties = properties;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (FACTORY == null) {
            FACTORY = Platform.getPlatformAdmin().getFactory();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.fModels.length + 1));
        this.fState = FACTORY.createState(true);
        IPluginModelBase[] iPluginModelBaseArray = this.fModels;
        int n = this.fModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase fModel = iPluginModelBaseArray[n2];
            BundleDescription bundle = fModel.getBundleDescription();
            if (bundle != null) {
                this.fState.addBundle(FACTORY.createBundleDescription(bundle));
            }
            subMonitor.split(1);
            ++n2;
        }
        this.fState.setPlatformProperties((Dictionary[])this.fProperties);
        this.fState.resolve(false);
        subMonitor.split(1);
    }

    public Map<Object, Object[]> getResolverErrors() {
        BundleDescription[] bundles;
        HashSet<String> alreadyDuplicated = new HashSet<String>();
        HashMap<Object, Object[]> map = new HashMap<Object, Object[]>();
        BundleDescription[] bundleDescriptionArray = bundles = this.fState.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription[] dups;
            BundleDescription bundle = bundleDescriptionArray[n2];
            if (!bundle.isResolved()) {
                map.put(bundle, this.fState.getResolverErrors(bundle));
            } else if (bundle.isSingleton() && !alreadyDuplicated.contains(bundle.getSymbolicName()) && (dups = this.fState.getBundles(bundle.getSymbolicName())).length > 1) {
                alreadyDuplicated.add(bundle.getSymbolicName());
                MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, NLS.bind((String)PDECoreMessages.BundleValidationOperation_multiple_singletons, (Object[])new String[]{Integer.toString(dups.length), bundle.getSymbolicName()}), null);
                BundleDescription[] bundleDescriptionArray2 = dups;
                int n3 = dups.length;
                int n4 = 0;
                while (n4 < n3) {
                    BundleDescription dup = bundleDescriptionArray2[n4];
                    status.add((IStatus)new Status(4, "org.eclipse.pde.core", dup.getLocation()));
                    ++n4;
                }
                map.put(bundle, new Object[]{status});
            }
            ++n2;
        }
        return map;
    }

    public State getState() {
        return this.fState;
    }

    public boolean hasErrors() {
        if (this.fState.getHighestBundleId() > -1L) {
            BundleDescription[] bundles;
            BundleDescription[] bundleDescriptionArray = bundles = this.fState.getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription[] dups;
                BundleDescription bundle = bundleDescriptionArray[n2];
                if (!bundle.isResolved()) {
                    return true;
                }
                if (bundle.isSingleton() && (dups = this.fState.getBundles(bundle.getSymbolicName())).length > 1) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

