/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.VerticalPositionFunction;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.RefreshOrderingHelper;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEndsOrdering;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;

public class RefreshGraphicalOrderingOperation
extends AbstractModelChangeOperation<Boolean> {
    private final SequenceDDiagram sequenceDiagram;

    public RefreshGraphicalOrderingOperation(SequenceDiagram sequenceDiagram) {
        super(Messages.RefreshGraphicalOrderingOperation_operationName);
        this.sequenceDiagram = sequenceDiagram.getSequenceDDiagram();
    }

    public Boolean execute() {
        EventEndsOrdering graphicalOrdering = this.sequenceDiagram.getGraphicalOrdering();
        if (graphicalOrdering != null) {
            return this.refreshGlobalOrdering(graphicalOrdering);
        }
        return false;
    }

    private boolean refreshGlobalOrdering(EventEndsOrdering graphicalOrdering) {
        if (graphicalOrdering.eContainer() instanceof SequenceDDiagram) {
            return this.refreshGlobalOrdering(graphicalOrdering, new CustomVerticalPositionFunction(this.sequenceDiagram));
        }
        return false;
    }

    private boolean refreshGlobalOrdering(EventEndsOrdering graphicalOrdering, VerticalPositionFunction verticalPosition) {
        final LoadingCache positions = CacheBuilder.newBuilder().build(CacheLoader.from((Function)verticalPosition));
        Predicate<EventEnd> isValidEnd = new Predicate<EventEnd>(){

            public boolean apply(EventEnd input) {
                try {
                    Integer pos = (Integer)positions.get((Object)input);
                    return pos != Integer.MAX_VALUE && pos != -2147483647;
                }
                catch (ExecutionException executionException) {
                    return false;
                }
            }
        };
        ArrayList allEnds = Lists.newArrayList((Iterable)Iterables.filter(this.getAllEventEnds(), (Predicate)isValidEnd));
        Collections.sort(allEnds, Ordering.natural().onResultOf((Function)new Function<EventEnd, Integer>(){

            public Integer apply(EventEnd input) {
                try {
                    return (Integer)positions.get((Object)input);
                }
                catch (ExecutionException executionException) {
                    return Integer.MAX_VALUE;
                }
            }
        }));
        return RefreshOrderingHelper.updateIfNeeded(graphicalOrdering.getEventEnds(), allEnds);
    }

    protected Iterable<? extends EventEnd> getAllEventEnds() {
        return RefreshOrderingHelper.getAllEventEnds(this.sequenceDiagram);
    }

    private static class CustomVerticalPositionFunction
    extends VerticalPositionFunction {
        CustomVerticalPositionFunction(SequenceDDiagram diagram) {
            super(diagram);
        }

        @Override
        public Integer apply(EventEnd end) {
            Integer customPos = super.apply(end);
            if (customPos != Integer.MAX_VALUE || customPos != -2147483647) {
                customPos = customPos * 10;
                if (end instanceof SingleEventEnd) {
                    SingleEventEnd see = (SingleEventEnd)end;
                    customPos = see.isStart() ? Integer.valueOf(customPos - 1) : Integer.valueOf(customPos + 1);
                }
            }
            return customPos;
        }
    }
}

