/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.presentation;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.editor.tools.api.menu.AbstractMenuBuilder;
import org.eclipse.sirius.editor.tools.api.menu.CompositeMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.MenuBuildersManager;
import org.eclipse.sirius.editor.tools.internal.menu.OthersMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.ConditionalStyleMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.CustomizationMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.EditToolsMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.ExtensionsMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.MenuToolsMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.NavigationToolsMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.OperationsMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.RepresentationCreationToolsMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.RepresentationMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.RepresentationTemplateMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.StyleMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.ValidationMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.VariablesMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.child.ViewpointAndPaletteMenuBuilder;
import org.eclipse.sirius.editor.tools.internal.menu.refactoring.RefactoringMenu;
import org.eclipse.sirius.editor.tools.internal.presentation.CustomSiriusAdapterFactoryLabelProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class CustomSiriusActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    private static final String UI_ACTIONS = "ui-actions";
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(SiriusEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                CustomSiriusActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                SiriusEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(SiriusEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return CustomSiriusActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (CustomSiriusActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)CustomSiriusActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected IAction showType = new ShowTypeAction();
    private final Collection<AbstractMenuBuilder> builders;
    private final OthersMenuBuilder other;
    private final RefactoringMenu refactoring;

    public CustomSiriusActionBarContributor() {
        super(1);
        if (!Movida.isEnabled()) {
            this.loadResourceAction = new LoadResourceAction();
        }
        this.validateAction = new ValidateAction();
        this.controlAction = new ControlAction();
        this.builders = new ArrayList<AbstractMenuBuilder>();
        this.initMenusBuilders();
        this.other = new OthersMenuBuilder(this.builders);
        this.refactoring = new RefactoringMenu();
    }

    private void initMenusBuilders() {
        ArrayList allMenusBuilders = Lists.newArrayList();
        allMenusBuilders.add(new EditToolsMenuBuilder());
        allMenusBuilders.add(new RepresentationCreationToolsMenuBuilder());
        allMenusBuilders.add(new MenuToolsMenuBuilder());
        allMenusBuilders.add(new RepresentationMenuBuilder());
        allMenusBuilders.add(new RepresentationTemplateMenuBuilder());
        allMenusBuilders.add(new NavigationToolsMenuBuilder());
        allMenusBuilders.add(new VariablesMenuBuilder());
        allMenusBuilders.add(new StyleMenuBuilder());
        allMenusBuilders.add(new CustomizationMenuBuilder());
        allMenusBuilders.add(new ConditionalStyleMenuBuilder());
        allMenusBuilders.add(new OperationsMenuBuilder());
        allMenusBuilders.add(new ValidationMenuBuilder());
        allMenusBuilders.add(new ExtensionsMenuBuilder());
        allMenusBuilders.add(new ViewpointAndPaletteMenuBuilder());
        allMenusBuilders.addAll(MenuBuildersManager.getInstance().getContributedMenuBuilders());
        LinkedHashMultimap c = LinkedHashMultimap.create();
        for (AbstractMenuBuilder builder : allMenusBuilders) {
            c.put((Object)builder.getLabel(), (Object)builder);
        }
        ArrayList computedBuilders = Lists.newArrayList();
        for (String label : c.keySet()) {
            if (c.get((Object)label).size() > 1) {
                computedBuilders.add(new CompositeMenuBuilder(label, c.get((Object)label)));
                continue;
            }
            computedBuilders.add((AbstractMenuBuilder)c.get((Object)label).iterator().next());
        }
        Comparator<AbstractMenuBuilder> comparator = new Comparator<AbstractMenuBuilder>(){

            @Override
            public int compare(AbstractMenuBuilder builder1, AbstractMenuBuilder builder2) {
                int diff = builder1.getPriority() - builder2.getPriority();
                if (diff == 0) {
                    return Collator.getInstance().compare(builder1.getLabel(), builder2.getLabel());
                }
                return diff;
            }
        };
        Collections.sort(computedBuilders, comparator);
        this.builders.addAll(computedBuilders);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("viewpoint-settings"));
        toolBarManager.add((IContributionItem)new Separator("viewpoint-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(SiriusEditorPlugin.INSTANCE.getString("_UI_SiriusEditor_menu"), "designerMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.depopulateMenus();
        Collection newChildDescriptors = null;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
        }
        if (newChildDescriptors != null) {
            this.updateChildDescriptorMenus(selection, newChildDescriptors);
        }
        this.populateMenus();
    }

    private void depopulateMenus() {
        for (AbstractMenuBuilder builder : this.builders) {
            builder.depopulateMenu();
        }
        this.other.depopulateMenu();
        this.refactoring.depopulateMenu();
    }

    private void updateChildDescriptorMenus(ISelection selection, Collection<?> newChildDescriptors) {
        for (AbstractMenuBuilder builder : this.builders) {
            builder.update(newChildDescriptors, selection, this.activeEditorPart);
        }
        this.other.update(newChildDescriptors, selection, this.activeEditorPart);
        this.refactoring.update((Collection)newChildDescriptors, selection, this.activeEditorPart);
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            Iterator<?> i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, i.next()));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            Iterator<?> i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, i.next()));
            }
        }
        return actions;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        this.insertInParentMenu(menuManager);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
    }

    private void insertInParentMenu(IMenuManager menuManager) {
        for (AbstractMenuBuilder builder : this.builders) {
            if ("Refactor".equals(builder.getLabel())) {
                builder.insertAfterInContainer(menuManager);
                continue;
            }
            builder.insertBeforeInContainer(menuManager);
        }
        this.other.insertBeforeInContainer(menuManager);
        this.refactoring.insertAfterInContainer(menuManager);
    }

    private void populateMenus() {
        for (AbstractMenuBuilder builder : this.builders) {
            builder.populateMenu();
        }
        this.other.populateMenu();
        this.refactoring.populateMenu();
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator(UI_ACTIONS));
        this.showType.setText(this.showType.getText());
        if (this.showType.isEnabled()) {
            this.showType.setEnabled(true);
            menuManager.insertAfter(UI_ACTIONS, this.showType);
        }
        menuManager.insertAfter(UI_ACTIONS, this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter(UI_ACTIONS, this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    private final class ShowTypeAction
    extends Action {
        private final String showText = SiriusEditorPlugin.INSTANCE.getString("_UI_ShowType_menu_item");
        private final String hideText = SiriusEditorPlugin.INSTANCE.getString("_UI_HideType_menu_item");

        private ShowTypeAction() {
        }

        public void run() {
            CustomSiriusAdapterFactoryLabelProvider labelProvider = this.getCustomLabelProvider();
            if (labelProvider != null) {
                labelProvider.setShowTypes(!labelProvider.isShowTypes());
                this.setText(this.getText());
                CustomSiriusActionBarContributor.this.refreshViewerAction.run();
            }
        }

        private CustomSiriusAdapterFactoryLabelProvider getCustomLabelProvider() {
            Viewer viewer;
            if (CustomSiriusActionBarContributor.this.activeEditor instanceof IViewerProvider && (viewer = ((IViewerProvider)CustomSiriusActionBarContributor.this.activeEditor).getViewer()) instanceof ContentViewer) {
                IBaseLabelProvider labelProvider = ((ContentViewer)viewer).getLabelProvider();
                if (labelProvider instanceof DecoratingStyledCellLabelProvider) {
                    labelProvider = ((DecoratingStyledCellLabelProvider)labelProvider).getStyledStringProvider();
                }
                if (labelProvider instanceof CustomSiriusAdapterFactoryLabelProvider) {
                    return (CustomSiriusAdapterFactoryLabelProvider)labelProvider;
                }
            }
            return null;
        }

        public String getText() {
            CustomSiriusAdapterFactoryLabelProvider labelProvider = this.getCustomLabelProvider();
            if (labelProvider != null) {
                return labelProvider.isShowTypes() ? this.hideText : this.showText;
            }
            return super.getText();
        }

        public boolean isEnabled() {
            return this.getCustomLabelProvider() != null;
        }
    }
}

