/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.metamodel.operations;

import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.tools.internal.Messages;

public final class DColumnOperations {
    private DColumnOperations() {
    }

    public static Collection<DCell> getOrderedCells(DColumn column) {
        final HashMap lineIndices = Maps.newHashMap();
        DColumnOperations.fillIndices(column.getTable(), lineIndices, 0);
        Ordering ordering = Ordering.from((Comparator)new Comparator<DCell>(){

            @Override
            public int compare(DCell a, DCell b) {
                int result = 0;
                DLine lineA = a.getLine();
                DLine lineB = b.getLine();
                if (lineA == null) {
                    result = -1;
                } else if (lineB == null) {
                    result = 1;
                } else {
                    Integer aIndex = (Integer)lineIndices.get(lineA);
                    Integer bIndex = (Integer)lineIndices.get(lineB);
                    if (aIndex == null || bIndex == null) {
                        throw new RuntimeException(Messages.Table_UnexpectedExceptionMessage);
                    }
                    return aIndex - bIndex;
                }
                return result;
            }
        });
        List result = ordering.sortedCopy(column.getCells());
        return result;
    }

    private static int fillIndices(LineContainer container, Map<DLine, Integer> lineIndices, int i) {
        int j = i;
        for (DLine line : container.getLines()) {
            if (line.getContainer() != null) {
                lineIndices.put(line, j);
            } else {
                lineIndices.put(line, -1);
            }
            ++j;
            j = DColumnOperations.fillIndices(line, lineIndices, j);
        }
        return j;
    }
}

