/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.session;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class OpenRepresentationsAction
extends Action {
    private Collection<DRepresentationDescriptor> representationsToOpen;

    public OpenRepresentationsAction(Collection<DRepresentationDescriptor> repDesriptors) {
        super(Messages.OpenRepresentationsAction_name);
        if (repDesriptors != null) {
            this.representationsToOpen = Sets.newLinkedHashSet((Iterable)Iterables.filter(repDesriptors, (Predicate)Predicates.notNull()));
        }
    }

    public OpenRepresentationsAction(DRepresentationDescriptor repDesc) {
        this(Collections.singletonList(repDesc));
    }

    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        try {
            ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) {
                    OpenRepresentationsAction.this.openRepresentations(OpenRepresentationsAction.this.representationsToOpen, pm);
                }
            };
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, null);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void openRepresentations(Collection<DRepresentationDescriptor> selection, IProgressMonitor monitor) {
        String taskName = Messages.OpenRepresentationsAction_openRepresentationTask;
        if (selection.size() > 1) {
            taskName = Messages.OpenRepresentationsAction_openRepresentationsTask;
        }
        try {
            monitor.beginTask(taskName, 5 * selection.size());
            for (DRepresentationDescriptor repDesc : selection) {
                IEditorPart part;
                Session session = new EObjectQuery(repDesc.getTarget()).getSession();
                monitor.worked(1);
                if (session == null || !((part = DialectUIManager.INSTANCE.openEditor(session, repDesc.getRepresentation(), (IProgressMonitor)new SubProgressMonitor(monitor, 3))) instanceof DialectEditor)) continue;
                this.updateUISession((DialectEditor)part, session);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void updateUISession(DialectEditor part, Session session) {
        IEditingSession uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(session);
        uiSession.open();
        uiSession.attachEditor(part);
    }
}

