/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.newmodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.ecore.EPackageMetaData;
import org.eclipse.sirius.ui.tools.internal.wizards.newmodel.CreateEMFModelWizardDataModel;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class SelectRootElementWizardPage
extends WizardPage
implements PropertyChangeListener {
    private Image eClassIcon = ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EClass"));
    private Text rootElementText;
    private Button rootElementCheckbox;
    private FilteredList rootElementFilteredList;
    private String rootElementFilter;
    private CreateEMFModelWizardDataModel dataModel;

    public SelectRootElementWizardPage(CreateEMFModelWizardDataModel dataModel) {
        super("SelectRootElementWizardPage");
        this.dataModel = dataModel;
        this.setTitle(Messages.SelectRootElementWizardPage_title);
        this.setDescription(Messages.SelectRootElementWizardPage_description);
    }

    public void setRootElementFilter(String filter) {
        if (this.rootElementText == null) {
            this.rootElementFilter = filter;
        } else {
            this.rootElementText.setText(filter);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        CLabel lblSelectRootElement = new CLabel(container, 0);
        lblSelectRootElement.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblSelectRootElement.setText(Messages.SelectRootElementWizardPage_label);
        this.createRootElementFilterText(container);
        this.createRootElementCheckbox(container);
        this.createRootElementFilteredList(container);
        this.setRootElementFilter("*");
        this.rootElementCheckbox.setSelection(true);
    }

    private void createRootElementFilterText(Composite parent) {
        this.rootElementText = new Text(parent, 2048);
        this.rootElementText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.rootElementText.setText(this.rootElementFilter == null ? "" : this.rootElementFilter);
        this.rootElementText.addListener(24, event -> this.rootElementFilteredList.setFilter(this.rootElementText.getText()));
        this.rootElementText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    SelectRootElementWizardPage.this.rootElementFilteredList.setFocus();
                }
            }
        });
    }

    private void createRootElementCheckbox(Composite parent) {
        this.rootElementCheckbox = new Button(parent, 32);
        this.rootElementCheckbox.setLayoutData((Object)new GridData(4, 16384, true, false, 1, 1));
        this.rootElementCheckbox.setText(Messages.SelectRootElementWizardPage_checkboxLabel);
        this.rootElementCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRootElementWizardPage.this.updateRootElementFilteredList();
            }
        });
    }

    private void createRootElementFilteredList(Composite parent) {
        this.rootElementFilteredList = new FilteredList(parent, 68356, (ILabelProvider)new RootElementsListLabelProvider(), true, false, false);
        this.rootElementFilteredList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.rootElementFilteredList.setFilter(this.rootElementFilter == null ? "" : this.rootElementFilter);
        this.rootElementFilteredList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRootElementWizardPage.this.updateSelectedRootElement();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedPackage".equals(evt.getPropertyName())) {
            this.updateRootElementFilteredList();
            this.updateSelectedRootElement();
        }
    }

    private void updateSelectedRootElement() {
        Object[] selection = this.rootElementFilteredList.getSelection();
        if (selection.length == 1) {
            this.dataModel.setSelectedRootElement((EClass)selection[0]);
            this.setPageComplete(true);
        } else {
            EClass preferredRootElement = this.getPreferredRootElementFromEPackageExtraData(this.dataModel.getSelectedPackage());
            if (preferredRootElement != null) {
                this.dataModel.setSelectedRootElement(preferredRootElement);
                this.setPageComplete(true);
            } else {
                this.dataModel.setSelectedRootElement(null);
                this.setPageComplete(false);
            }
        }
    }

    private void updateRootElementFilteredList() {
        if (this.rootElementCheckbox != null) {
            Object[] classesArray = this.rootElementCheckbox.getSelection() ? this.getFilteredConcreteClasses(this.dataModel.getSelectedPackage()).toArray() : this.getConcreteClasses(this.dataModel.getSelectedPackage()).toArray();
            this.rootElementFilteredList.setElements(classesArray);
            EClass preferredRootElement = this.getPreferredRootElementFromEPackageExtraData(this.dataModel.getSelectedPackage());
            if (preferredRootElement != null) {
                this.rootElementFilteredList.setSelection(new Object[]{preferredRootElement});
            }
        }
    }

    private Collection<EClass> getConcreteClasses(EPackage ePackage) {
        HashSet<EClass> concreteClasses = new HashSet<EClass>();
        if (ePackage != null) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass) || ((EClass)eClassifier).isAbstract() || ((EClass)eClassifier).isInterface()) continue;
                concreteClasses.add((EClass)eClassifier);
            }
        }
        return concreteClasses;
    }

    private Collection<EClass> getFilteredConcreteClasses(EPackage ePackage) {
        Collection<EClass> concreteClasses = this.getConcreteClasses(ePackage);
        if (ePackage != null) {
            String nsURI = ePackage.getNsURI();
            EPackageMetaData metaData = DslCommonPlugin.INSTANCE.getEPackageMetaData(nsURI);
            List<Object> roots = new ArrayList<EClass>();
            if (metaData != null && !metaData.getSuggestedRoots().isEmpty()) {
                roots = concreteClasses.stream().filter(c -> metaData.getSuggestedRoots().contains(c.getName())).collect(Collectors.toList());
            }
            if (!roots.isEmpty()) {
                return roots;
            }
        }
        return this.inferRootElementsCandidates(concreteClasses);
    }

    private Collection<EClass> inferRootElementsCandidates(Collection<EClass> concreteClasses) {
        HashSet<EClass> filteredConcreteClasses = new HashSet<EClass>(concreteClasses);
        for (EClass eClass : concreteClasses) {
            if (!filteredConcreteClasses.contains(eClass)) continue;
            eClass.getEAllReferences().stream().filter(EReference::isContainment).forEach(eReference -> {
                EClassifier eType = eReference.getEType();
                if (concreteClasses.contains(eType) && eType != eClass) {
                    filteredConcreteClasses.remove(eType);
                } else {
                    concreteClasses.stream().filter(c -> c.getEAllSuperTypes().contains((Object)eType)).forEach(c -> {
                        boolean bl = filteredConcreteClasses.remove(c);
                    });
                }
            });
        }
        return filteredConcreteClasses;
    }

    private EClass getPreferredRootElementFromEPackageExtraData(EPackage ePackage) {
        EClassifier result;
        String nsURI;
        EPackageMetaData metaData;
        if (ePackage != null && (metaData = DslCommonPlugin.INSTANCE.getEPackageMetaData(nsURI = ePackage.getNsURI())) != null && !metaData.getSuggestedRoots().isEmpty() && (result = ePackage.getEClassifier((String)metaData.getSuggestedRoots().get(0))) instanceof EClass) {
            return (EClass)result;
        }
        return null;
    }

    private class RootElementsListLabelProvider
    extends LabelProvider {
        private RootElementsListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof EClass) {
                return ((EClass)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return SelectRootElementWizardPage.this.eClassIcon;
        }
    }
}

