/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.validation.description.constraints;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.api.interpreter.context.SiriusInterpreterContextFactory;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;

public class ValidFeatureNameConstraint
extends AbstractConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        LinkedHashSet statuses = Sets.newLinkedHashSet();
        for (EAttribute feature : target.eClass().getEAllAttributes()) {
            IStatus status;
            if (!DescriptionPackage.eINSTANCE.getFeatureName().equals(feature.getEAttributeType()) || (status = this.checkExpression(ctx, target, (EStructuralFeature)feature)) == null) continue;
            statuses.add(status);
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        IStatus returnStatus = statuses.size() == 1 ? (IStatus)statuses.iterator().next() : ConstraintStatus.createMultiStatus((IValidationContext)ctx, (Collection)statuses);
        return returnStatus;
    }

    private IStatus checkExpression(IValidationContext ctx, EObject target, EStructuralFeature feature) {
        IStatus returnStatus = ctx.createSuccessStatus();
        String expression = (String)target.eGet(feature);
        IInterpreterContext context = SiriusInterpreterContextFactory.createInterpreterContext(target, feature);
        VariableType variableType = context.getTargetType();
        if (!StringUtil.isEmpty((String)expression)) {
            Optional<EStructuralFeature> optional;
            if (this.isTypeIdentified(variableType) && !(optional = variableType.getPossibleTypes().stream().flatMap(type -> type.search(context.getAvailableEPackages()).stream()).filter(EClass.class::isInstance).map(EClass.class::cast).flatMap(eClass -> eClass.getEAllStructuralFeatures().stream()).filter(f -> f.getName().equals(expression)).findFirst()).isPresent()) {
                returnStatus = ctx.createFailureStatus(new Object[]{expression, variableType});
            }
        } else {
            returnStatus = ctx.createFailureStatus(new Object[]{expression, variableType});
        }
        return returnStatus;
    }

    private boolean isTypeIdentified(VariableType variableType) {
        return variableType.hasDefinition() && variableType.getPossibleTypes().stream().anyMatch(tn -> !TypeName.EOBJECT_TYPENAME.equals(tn));
    }
}

