/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.dialogs;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.edit.internal.swt.dialogs.ModelelementSelectionDialog;
import org.eclipse.emf.ecp.edit.internal.swt.dialogs.RelevanceWrappedLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MESuggestedSelectionDialog
extends ModelelementSelectionDialog {
    private Map<EObject, Double> relevanceMap;
    private Label label;
    private boolean warning;
    private RelevanceWrappedLabelProvider relevanceWrappedLabelProvider;
    private RelevanceDetailsLabelProvider relevanceDetailsLabelProvider;

    public MESuggestedSelectionDialog(String title, String message, boolean blockOnOpen, EObject baseElement, EReference reference, Collection<EObject> elements, Shell shell) {
        super(reference.isMany(), shell);
        this.setTitle(title);
        this.setMessage(message);
        this.setBlockOnOpen(blockOnOpen);
        this.relevanceMap = new HashMap<EObject, Double>(elements.size());
        this.setModelElements(elements);
        this.relevanceMap = new HashMap<EObject, Double>();
        this.relevanceWrappedLabelProvider = new RelevanceWrappedLabelProvider((AdapterFactory)this.composedAdapterFactory, this.relevanceMap);
        this.setLabelProvider((ILabelProvider)this.relevanceWrappedLabelProvider);
        this.setListLabelProvider(this.getLabelProvider());
        this.relevanceDetailsLabelProvider = new RelevanceDetailsLabelProvider();
        this.setDetailsLabelProvider((ILabelProvider)this.relevanceDetailsLabelProvider);
    }

    @Override
    public boolean close() {
        this.relevanceWrappedLabelProvider.dispose();
        this.relevanceDetailsLabelProvider.dispose();
        return super.close();
    }

    @Override
    protected Control createExtendedContentArea(Composite parent) {
        if (this.warning) {
            this.label = new Label(parent, 64);
            this.label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.label.setForeground(Display.getDefault().getSystemColor(3));
            this.label.setText("This work item does not annotate any model elements. For assignee recommendation to work fine, you should first link this work item with a model element (preferably a functional requirement).");
            return this.label;
        }
        return null;
    }

    @Override
    protected Comparator<EObject> getItemsComparator() {
        return new RelevanceMapComparator();
    }

    private boolean isRelevant(Double val) {
        return val != null;
    }

    class RelevanceDetailsLabelProvider
    extends LabelProvider {
        RelevanceDetailsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof EObject) {
                String text = super.getText(element);
                Double sim = (Double)MESuggestedSelectionDialog.this.relevanceMap.get(element);
                if (sim != null) {
                    text = "Relevance: " + sim + ". " + text;
                }
                return text;
            }
            if (element == null) {
                return "No item selected.";
            }
            return "Multiple elements selected.";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RelevanceMapComparator
    implements Comparator<EObject> {
        RelevanceMapComparator() {
        }

        @Override
        public int compare(EObject o1, EObject o2) {
            String name1 = MESuggestedSelectionDialog.this.adapterFactoryLabelProvider.getText((Object)o1);
            String name2 = MESuggestedSelectionDialog.this.adapterFactoryLabelProvider.getText((Object)o2);
            Double val1 = (Double)MESuggestedSelectionDialog.this.relevanceMap.get(o1);
            Double val2 = (Double)MESuggestedSelectionDialog.this.relevanceMap.get(o2);
            if (!MESuggestedSelectionDialog.this.isRelevant(val1) && !MESuggestedSelectionDialog.this.isRelevant(val2)) {
                if (name1 != null && name2 != null) {
                    return name1.compareToIgnoreCase(name2);
                }
                return 0;
            }
            if (!MESuggestedSelectionDialog.this.isRelevant(val1)) {
                return 1;
            }
            if (!MESuggestedSelectionDialog.this.isRelevant(val2)) {
                return -1;
            }
            return val2.compareTo(val1);
        }
    }
}

