/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.core.ECPProjectManager;
import org.eclipse.emf.ecp.core.ECPProviderRegistry;
import org.eclipse.emf.ecp.core.ECPRepositoryManager;
import org.eclipse.emf.ecp.internal.core.ECPProjectManagerImpl;
import org.eclipse.emf.ecp.internal.core.ECPProviderRegistryImpl;
import org.eclipse.emf.ecp.internal.core.ECPRepositoryManagerImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.ecp.core";
    private static Activator instance;
    private static ECPProjectManager ecpProjectManager;
    private static ECPRepositoryManager ecpRepositoryManager;
    private static ECPProviderRegistry ecpProviderRegistry;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        instance = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        ECPProjectManagerImpl.INSTANCE.deactivate();
        ECPRepositoryManagerImpl.INSTANCE.deactivate();
        ECPProviderRegistryImpl.INSTANCE.deactivate();
        instance = null;
        super.stop(bundleContext);
    }

    public static Activator getInstance() {
        return instance;
    }

    public static void log(String message) {
        instance.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void log(int status, String message) {
        instance.getLog().log((IStatus)new Status(status, PLUGIN_ID, message));
    }

    private static void log(IStatus status) {
        instance.getLog().log(status);
    }

    public static String log(Throwable t) {
        IStatus status = Activator.getStatus(t);
        Activator.log(status);
        return status.getMessage();
    }

    private static IStatus getStatus(Throwable t) {
        if (t instanceof CoreException) {
            CoreException coreException = (CoreException)t;
            return coreException.getStatus();
        }
        String msg = t.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = t.getClass().getName();
        }
        return new Status(4, PLUGIN_ID, msg, t);
    }

    public static ECPProjectManager getECPProjectManager() {
        if (ecpProjectManager == null) {
            ServiceReference serviceRef = instance.getBundle().getBundleContext().getServiceReference(ECPProjectManager.class);
            ecpProjectManager = (ECPProjectManager)instance.getBundle().getBundleContext().getService(serviceRef);
        }
        return ecpProjectManager;
    }

    public static ECPRepositoryManager getECPRepositoryManager() {
        if (ecpRepositoryManager == null) {
            ServiceReference serviceRef = instance.getBundle().getBundleContext().getServiceReference(ECPRepositoryManager.class);
            ecpRepositoryManager = (ECPRepositoryManager)instance.getBundle().getBundleContext().getService(serviceRef);
        }
        return ecpRepositoryManager;
    }

    public static ECPProviderRegistry getECPProviderRegistry() {
        if (ecpProviderRegistry == null) {
            ServiceReference serviceRef = instance.getBundle().getBundleContext().getServiceReference(ECPProviderRegistry.class);
            ecpProviderRegistry = (ECPProviderRegistry)instance.getBundle().getBundleContext().getService(serviceRef);
        }
        return ecpProviderRegistry;
    }
}

