/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPElement;
import org.eclipse.emf.ecp.core.util.ECPFilterProvider;
import org.eclipse.emf.ecp.core.util.ECPModelContextAdapter;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectPreDeleteObserver;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.internal.core.ECPProjectManagerImpl;
import org.eclipse.emf.ecp.internal.core.util.PropertiesElement;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.emf.ecp.spi.core.util.ECPDisposable;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ECPProjectImpl
extends PropertiesElement
implements InternalProject,
ECPDisposable.DisposeListener {
    private InternalRepository repository;
    private InternalProvider provider;
    private Object providerSpecificData;
    private Set<EPackage> filteredEPackages = Collections.emptySet();
    private Set<EClass> filteredEClasses = Collections.emptySet();
    private EditingDomain editingDomain;
    private boolean open;

    public ECPProjectImpl(InternalProvider provider, String name, ECPProperties properties) {
        super(name, properties);
        this.provider = provider;
        this.open = true;
        this.setupFilteredEPackages();
        this.notifyProvider(InternalProvider.LifecycleEvent.INIT);
    }

    public ECPProjectImpl(ECPRepository repository, String name, ECPProperties properties) {
        super(name, properties);
        if (repository == null) {
            throw new IllegalArgumentException("Repository is null");
        }
        this.setRepository((InternalRepository)repository);
        this.provider = this.getRepository().getProvider();
        this.open = true;
        this.setupFilteredEPackages();
        this.notifyProvider(InternalProvider.LifecycleEvent.INIT);
    }

    public ECPProjectImpl(ObjectInput in) throws IOException {
        super(in);
        boolean shared = in.readBoolean();
        if (shared) {
            String repositoryName = in.readUTF();
            InternalRepository repository = (InternalRepository)ECPUtil.getECPRepositoryManager().getRepository(repositoryName);
            if (repository == null) {
                repository = new Disposed(repositoryName);
            }
            this.setRepository(repository);
            this.provider = repository.getProvider();
        } else {
            String providerName = in.readUTF();
            this.provider = (InternalProvider)ECPUtil.getECPProviderRegistry().getProvider(providerName);
            if (this.provider == null) {
                throw new IllegalStateException("Provider not found: " + providerName);
            }
        }
        this.open = in.readBoolean();
        int filteredPackageSize = in.readInt();
        this.filteredEPackages = new HashSet<EPackage>();
        int i = 0;
        while (i < filteredPackageSize) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(in.readUTF());
            if (ePackage != null) {
                this.filteredEPackages.add(ePackage);
            }
            ++i;
        }
        int filteredEClassSize = in.readInt();
        this.filteredEClasses = new HashSet<EClass>();
        int i2 = 0;
        while (i2 < filteredEClassSize) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(in.readUTF());
            EClassifier eClassifier = ePackage.getEClassifier(in.readUTF());
            if (eClassifier instanceof EClass) {
                this.filteredEClasses.add((EClass)eClassifier);
            }
            ++i2;
        }
    }

    private void setupFilteredEPackages() {
        ArrayList<ECPFilterProvider> filterProviders = new ArrayList<ECPFilterProvider>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.ecp.core.filters");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement configurationElement = extension.getConfigurationElements()[0];
            try {
                ECPFilterProvider filterProvider = (ECPFilterProvider)configurationElement.createExecutableExtension("class");
                filterProviders.add(filterProvider);
            }
            catch (CoreException ex) {
                Activator.log(ex);
            }
            ++n2;
        }
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        HashSet<String> filteredNsUris = new HashSet<String>();
        for (ECPFilterProvider filterProvider : filterProviders) {
            filteredNsUris.addAll(filterProvider.getHiddenPackages());
        }
        HashSet relevantURIs = new HashSet(EPackage.Registry.INSTANCE.keySet());
        relevantURIs.removeAll(filteredNsUris);
        for (String nsUri : relevantURIs) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsUri);
            ePackages.add(ePackage);
        }
        this.setVisiblePackages(ePackages);
    }

    @Override
    public void write(ObjectOutput out) throws IOException {
        super.write(out);
        if (this.repository != null) {
            out.writeBoolean(true);
            out.writeUTF(this.repository.getName());
        } else {
            out.writeBoolean(false);
            out.writeUTF(this.provider.getName());
        }
        out.writeBoolean(this.open);
        out.writeInt(this.filteredEPackages.size());
        for (EPackage ePackage : this.filteredEPackages) {
            out.writeUTF(ePackage.getNsURI());
        }
        out.writeInt(this.filteredEClasses.size());
        for (EClass eClass : this.filteredEClasses) {
            out.writeUTF(eClass.getEPackage().getNsURI());
            out.writeUTF(eClass.getName());
        }
    }

    @Override
    public String getType() {
        return "Project";
    }

    @Override
    public void disposed(ECPDisposable disposable) {
        if (disposable == this.repository) {
            this.dispose();
        }
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    @Override
    public InternalProject getProject() {
        return this;
    }

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    private void setRepository(InternalRepository repository) {
        if (this.repository != null) {
            this.repository.removeDisposeListener(this);
        }
        this.repository = repository;
        if (this.repository != null) {
            this.repository.addDisposeListener(this);
        }
    }

    @Override
    public InternalProvider getProvider() {
        return this.provider;
    }

    @Override
    public Object getProviderSpecificData() {
        return this.providerSpecificData;
    }

    @Override
    public void setProviderSpecificData(Object providerSpecificData) {
        this.providerSpecificData = providerSpecificData;
    }

    @Override
    public void notifyObjectsChanged(Collection<Object> objects, boolean structural) {
        if (objects != null && objects.size() != 0) {
            ECPProjectManagerImpl.INSTANCE.notifyObjectsChanged(this, objects, structural);
        }
    }

    public synchronized EditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.editingDomain = this.getProvider().createEditingDomain(this);
        }
        return this.editingDomain;
    }

    public Object getAdapter(Class adapterType) {
        Object result;
        InternalProvider provider = this.getProvider();
        if (provider != null && !provider.isDisposed() && (result = provider.getAdapter(this, adapterType)) != null) {
            return result;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public ECPContainer getContext() {
        return this;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public void delete() {
        ECPUtil.getECPObserverBus().notify(ECPProjectPreDeleteObserver.class).projectDelete(this);
        this.getProvider().handleLifecycle(this, InternalProvider.LifecycleEvent.REMOVE);
        ECPProjectManagerImpl.INSTANCE.changeElements(Collections.singleton(this.getName()), null);
    }

    @Override
    public synchronized boolean isOpen() {
        return !this.isRepositoryDisposed() && this.open;
    }

    @Override
    public synchronized void open() {
        if (!this.isRepositoryDisposed()) {
            this.setOpen(true);
        }
    }

    @Override
    public synchronized void close() {
        if (!this.isRepositoryDisposed()) {
            this.setOpen(false);
        }
    }

    private boolean isRepositoryDisposed() {
        return this.repository != null && this.repository.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOpen(boolean open) {
        boolean modified = false;
        ECPProjectImpl eCPProjectImpl = this;
        synchronized (eCPProjectImpl) {
            if (open != this.open) {
                this.open = open;
                modified = true;
                this.notifyProvider(open ? InternalProvider.LifecycleEvent.INIT : InternalProvider.LifecycleEvent.DISPOSE);
                if (!open) {
                    this.providerSpecificData = null;
                    this.editingDomain = null;
                }
            }
        }
        if (modified) {
            ECPProjectManagerImpl.INSTANCE.changeProject(this, open, true);
        }
    }

    @Override
    public void notifyProvider(InternalProvider.LifecycleEvent event) {
        Notifier root;
        InternalProvider provider = this.getProvider();
        provider.handleLifecycle(this, event);
        if (event == InternalProvider.LifecycleEvent.INIT && (root = provider.getRoot(this)) != null) {
            root.eAdapters().add((Object)new ECPModelContextAdapter(this));
        }
    }

    @Override
    public void undispose(InternalRepository repository) {
        this.setRepository(repository);
        this.notifyProvider(InternalProvider.LifecycleEvent.INIT);
        if (this.open) {
            ECPProjectManagerImpl.INSTANCE.changeProject(this, true, true);
        }
    }

    private void dispose() {
        this.notifyProvider(InternalProvider.LifecycleEvent.DISPOSE);
        if (this.repository != null) {
            this.setRepository(new Disposed(this.repository.getName()));
        }
        this.providerSpecificData = null;
        this.editingDomain = null;
        ECPProjectManagerImpl.INSTANCE.changeProject(this, false, false);
    }

    @Override
    public EList<Object> getContents() {
        return this.getProvider().getElements(this);
    }

    @Override
    public Set<EPackage> getUnsupportedEPackages() {
        return this.getProvider().getUnsupportedEPackages(ECPUtil.getAllRegisteredEPackages(), this.getRepository());
    }

    @Override
    public void setVisiblePackages(Set<EPackage> filteredPackages) {
        this.filteredEPackages = filteredPackages;
        ECPProjectManagerImpl.INSTANCE.changeProject(this, this.open, true);
    }

    @Override
    public Set<EPackage> getVisiblePackages() {
        return this.filteredEPackages;
    }

    @Override
    public Set<EClass> getVisibleEClasses() {
        return this.filteredEClasses;
    }

    @Override
    public void setVisibleEClasses(Set<EClass> filteredEClasses) {
        this.filteredEClasses = filteredEClasses;
        ECPProjectManagerImpl.INSTANCE.changeProject(this, this.open, true);
    }

    @Override
    public Iterator<EObject> getReferenceCandidates(EObject modelElement, EReference eReference) {
        return this.getProvider().getLinkElements(this, modelElement, eReference);
    }

    @Override
    public void saveContents() {
        this.getProvider().doSave(this);
    }

    @Override
    public boolean hasDirtyContents() {
        return this.getProvider().isDirty(this);
    }

    @Override
    public void deleteElements(Collection<Object> objects) {
        this.getProvider().delete(this, objects);
        this.notifyObjectsChanged(Collections.singleton(this), true);
    }

    @Override
    public InternalProject clone(String name) {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Activator.log(ex);
        }
        ECPProjectImpl project = new ECPProjectImpl(this.getProvider(), name, ECPUtil.createProperties());
        project.setVisibleEClasses(this.getVisibleEClasses());
        project.setVisiblePackages(this.getVisiblePackages());
        this.getProvider().cloneProject(this, project);
        return project;
    }

    @Override
    public void saveProperties() {
        ECPProjectManagerImpl.INSTANCE.storeElement(this);
    }

    @Override
    public boolean isModelRoot(Object object) {
        return this.getProvider().getRoot(this).equals(object);
    }

    @Override
    public boolean contains(Object object) {
        return this.getProvider().contains(this, object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Disposed
    implements InternalRepository {
        private final String name;

        public Disposed(String name) {
            this.name = name;
        }

        public String getType() {
            return "Repository";
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isDisposed() {
            return true;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        @Override
        public String getLabel() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public int compareTo(ECPElement o) {
            return 0;
        }

        public ECPContainer getContext() {
            return null;
        }

        @Override
        public ECPProperties getProperties() {
            return null;
        }

        @Override
        public boolean canDelete() {
            return false;
        }

        @Override
        public void delete() {
        }

        @Override
        public boolean isStorable() {
            return false;
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
        }

        @Override
        public void setLabel(String label) {
        }

        @Override
        public void setDescription(String description) {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void addDisposeListener(ECPDisposable.DisposeListener listener) {
        }

        @Override
        public void removeDisposeListener(ECPDisposable.DisposeListener listener) {
        }

        @Override
        public InternalProvider getProvider() {
            return null;
        }

        @Override
        public Object getProviderSpecificData() {
            return null;
        }

        @Override
        public void setProviderSpecificData(Object data) {
        }

        @Override
        public void notifyObjectsChanged(Collection<Object> objects) {
        }
    }
}

