/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.internal.core.ECPRepositoryManagerImpl;
import org.eclipse.emf.ecp.internal.core.util.Disposable;
import org.eclipse.emf.ecp.internal.core.util.PropertiesElement;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.emf.ecp.spi.core.util.DisposeException;
import org.eclipse.emf.ecp.spi.core.util.ECPDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ECPRepositoryImpl
extends PropertiesElement
implements InternalRepository,
ECPDisposable.DisposeListener {
    private final Disposable disposable = new Disposable(this){

        protected void doDispose() {
            ECPRepositoryImpl.this.provider = null;
            ECPRepositoryImpl.this.providerSpecificData = null;
        }
    };
    private String label;
    private String description;
    private InternalProvider provider;
    private Object providerSpecificData;

    public ECPRepositoryImpl(ECPProvider provider, String name, ECPProperties properties) {
        super(name, properties);
        this.label = name;
        this.description = "";
        if (provider == null) {
            throw new IllegalArgumentException("Provider is null");
        }
        this.provider = (InternalProvider)provider;
        this.provider.addDisposeListener(this);
    }

    public ECPRepositoryImpl(ObjectInput in) throws IOException {
        super(in);
        this.label = in.readUTF();
        this.description = in.readUTF();
        String providerName = in.readUTF();
        this.provider = (InternalProvider)ECPUtil.getECPProviderRegistry().getProvider(providerName);
        if (this.provider == null) {
            throw new IllegalStateException("Provider not found: " + providerName);
        }
        this.provider.addDisposeListener(this);
    }

    @Override
    public String getType() {
        return "Repository";
    }

    @Override
    public void disposed(ECPDisposable disposable) throws DisposeException {
        if (disposable == this.provider) {
            this.dispose();
        }
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    @Override
    public void write(ObjectOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.label);
        out.writeUTF(this.description);
        out.writeUTF(this.provider.getName());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    public Object getAdapter(Class adapterType) {
        Object result;
        InternalProvider provider = this.getProvider();
        if (!provider.isDisposed() && (result = provider.getAdapter(this, adapterType)) != null) {
            return result;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    @Override
    public void dispose() {
        this.disposable.dispose();
    }

    @Override
    public void addDisposeListener(ECPDisposable.DisposeListener listener) {
        this.disposable.addDisposeListener(listener);
    }

    @Override
    public void removeDisposeListener(ECPDisposable.DisposeListener listener) {
        this.disposable.removeDisposeListener(listener);
    }

    @Override
    public InternalProvider getProvider() {
        return this.provider;
    }

    @Override
    public Object getProviderSpecificData() {
        return this.providerSpecificData;
    }

    @Override
    public void setProviderSpecificData(Object providerSpecificData) {
        this.providerSpecificData = providerSpecificData;
    }

    public ECPContainer getContext() {
        return this;
    }

    @Override
    public boolean canDelete() {
        return this.isStorable();
    }

    @Override
    public void delete() {
        if (!this.canDelete()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.provider.handleLifecycle(this, InternalProvider.LifecycleEvent.REMOVE);
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
        ECPRepositoryManagerImpl.INSTANCE.changeElements(Collections.singleton(this.getName()), null);
    }

    @Override
    public void notifyObjectsChanged(Collection<Object> objects) {
        if (objects != null && objects.size() != 0) {
            ECPRepositoryManagerImpl.INSTANCE.notifyObjectsChanged(this, objects);
        }
    }

    public InternalProject[] getOpenProjects() {
        ArrayList<InternalProject> result = new ArrayList<InternalProject>();
        for (ECPProject project : ECPUtil.getECPProjectManager().getProjects()) {
            if (!project.isOpen() || !project.getRepository().equals(this)) continue;
            result.add((InternalProject)project);
        }
        return result.toArray(new InternalProject[result.size()]);
    }
}

