/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPPropertiesObserver;
import org.eclipse.emf.ecp.internal.core.util.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties
extends Registry<Map.Entry<String, String>, ECPPropertiesObserver>
implements ECPProperties {
    public Properties() {
        this.activate();
    }

    public Properties(ObjectInput in) throws IOException {
        this.activate();
        int count = in.readInt();
        int i = 0;
        while (i < count) {
            String key = in.readUTF();
            String value = in.readUTF();
            this.addProperty(key, value);
            ++i;
        }
    }

    public void write(ObjectOutput out) throws IOException {
        Collection entries = this.getElements();
        out.writeInt(entries.size());
        for (Map.Entry entry : entries) {
            out.writeUTF((String)entry.getKey());
            out.writeUTF((String)entry.getValue());
        }
    }

    @Override
    public final void addProperty(String key, String value) {
        Property property = new Property(key, value);
        this.doChangeElements(null, Collections.singleton(property));
    }

    @Override
    public final void removeProperty(String key) {
        this.doChangeElements(Collections.singleton(key), null);
    }

    @Override
    public String getValue(String name) {
        Map.Entry element = (Map.Entry)this.getElement(name);
        return element == null ? null : (String)element.getValue();
    }

    @Override
    public Set<String> getKeys() {
        return this.getElementNames();
    }

    @Override
    public Collection<Map.Entry<String, String>> getProperties() {
        return this.getElements();
    }

    @Override
    public boolean hasProperties() {
        return this.hasElements();
    }

    @Override
    public ECPProperties copy() {
        ECPProperties copy = ECPUtil.createProperties();
        for (Map.Entry property : this.getElements()) {
            copy.addProperty((String)property.getKey(), (String)property.getValue());
        }
        return copy;
    }

    @Override
    protected String getElementName(Map.Entry<String, String> element) {
        return element.getKey();
    }

    @Override
    protected void notifyObservers(Collection<Map.Entry<String, String>> oldProperties, Collection<Map.Entry<String, String>> newProperties) throws Exception {
        ECPUtil.getECPObserverBus().notify(ECPPropertiesObserver.class).propertiesChanged(this, oldProperties, newProperties);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Property
    implements Map.Entry<String, String> {
        private final String key;
        private final String value;

        public Property(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.key) + " --> " + this.value;
        }
    }
}

