/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecp.core.util.ECPElement;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.internal.core.util.ElementRegistry;
import org.eclipse.emf.ecp.internal.core.util.InternalUtil;
import org.eclipse.net4j.util.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertiesStore<ELEMENT extends StorableElement, OBSERVER extends ECPObserver>
extends ElementRegistry<ELEMENT, OBSERVER> {
    private File folder;

    public final File getFolder() {
        return this.folder;
    }

    public final void setFolder(File folder) {
        this.checkInactive();
        this.folder = folder;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.folder == null) {
            throw new IllegalStateException("Folder is null");
        }
        if (this.folder.exists()) {
            if (!this.folder.isDirectory()) {
                throw new IllegalStateException("Not a folder: " + this.folder);
            }
        } else {
            this.folder.mkdirs();
        }
        this.load();
    }

    protected void load() {
        System.out.println("Loading " + this.getClass().getSimpleName() + " from " + this.folder.getAbsolutePath());
        HashSet<ELEMENT> elements = new HashSet<ELEMENT>();
        File[] fileArray = this.folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                File file = fileArray[n2];
                try {
                    if (!file.isFile()) break block7;
                    FileInputStream stream = null;
                    try {
                        stream = new FileInputStream(file);
                        ObjectInputStream in = new ObjectInputStream(stream);
                        ELEMENT element = this.loadElement(in);
                        elements.add(element);
                    }
                    finally {
                        if (stream != null) {
                            ((InputStream)stream).close();
                        }
                    }
                }
                catch (IOException ex) {
                    Activator.log(ex);
                }
            }
            ++n2;
        }
        this.doChangeElements(null, elements);
    }

    protected abstract ELEMENT loadElement(ObjectInput var1) throws IOException;

    @Override
    protected void elementsChanged(Collection<ELEMENT> oldElements, Collection<ELEMENT> newElements) {
        if (PropertiesStore.isDisposingElement()) {
            return;
        }
        if (this.isActive()) {
            for (StorableElement element : InternalUtil.getRemovedElements(oldElements, newElements)) {
                try {
                    File file = this.getFile(element);
                    file.delete();
                }
                catch (Exception ex) {
                    Activator.log(ex);
                }
            }
            for (StorableElement element : InternalUtil.getAddedElements(oldElements, newElements)) {
                if (!element.isStorable()) continue;
                this.storeElement(element);
            }
        }
    }

    protected void storeElement(ELEMENT element) {
        File file = this.getFile(element);
        File temp = new File(file.getParentFile(), String.valueOf(file.getName()) + ".tmp");
        if (temp.isFile()) {
            temp.delete();
        }
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(temp);
                ObjectOutputStream out = new ObjectOutputStream(stream);
                element.write(out);
                out.flush();
            }
            catch (Throwable throwable) {
                IOUtil.close(stream);
                throw throwable;
            }
            IOUtil.close((Closeable)stream);
            file.delete();
            temp.renameTo(file);
        }
        catch (Exception ex) {
            temp.delete();
            Activator.log(ex);
        }
    }

    protected File getFile(ELEMENT element) {
        return new File(this.folder, element.getName());
    }

    public static interface StorableElement
    extends ECPElement {
        public boolean isStorable();

        public void write(ObjectOutput var1) throws IOException;
    }
}

