/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecp.edit.ECPAbstractControl;
import org.eclipse.emf.ecp.edit.ECPControlContext;
import org.eclipse.emf.ecp.edit.ECPControlFactory;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTControl;
import org.eclipse.emf.ecp.edit.util.ECPModelElementChangeListener;
import org.eclipse.emf.ecp.editor.IEditorCompositeProvider;
import org.eclipse.emf.ecp.internal.editor.Activator;
import org.eclipse.emf.ecp.internal.editor.descriptor.AnnotationHiddenDescriptor;
import org.eclipse.emf.ecp.internal.editor.descriptor.AnnotationPositionDescriptor;
import org.eclipse.emf.ecp.internal.editor.descriptor.AnnotationPriorityDescriptor;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormEditorComposite
implements IEditorCompositeProvider {
    private ECPModelElementChangeListener modelElementChangeListener;
    private final ECPControlContext modelElementContext;
    private Map<EStructuralFeature, ECPAbstractControl> meControls = new LinkedHashMap<EStructuralFeature, ECPAbstractControl>();
    private Map<ECPAbstractControl, Diagnostic> valdiatedControls = new HashMap<ECPAbstractControl, Diagnostic>();
    private List<IItemPropertyDescriptor> leftColumnAttributes = new ArrayList<IItemPropertyDescriptor>();
    private List<IItemPropertyDescriptor> rightColumnAttributes = new ArrayList<IItemPropertyDescriptor>();
    private List<IItemPropertyDescriptor> bottomAttributes = new ArrayList<IItemPropertyDescriptor>();
    private Composite leftColumnComposite;
    private Composite rightColumnComposite;
    private Composite bottomComposite;
    private ComposedAdapterFactory composedAdapterFactory;

    public FormEditorComposite(ECPControlContext modelElementContext) {
        this.modelElementContext = modelElementContext;
        this.addModelElementListener();
    }

    private void addModelElementListener() {
        this.modelElementChangeListener = new ECPModelElementChangeListener(this.modelElementContext.getModelElement()){

            public void onChange(Notification notification) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        FormEditorComposite.this.updateLiveValidation();
                    }
                });
            }
        };
    }

    @Override
    public Composite createUI(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        topComposite.setBackground(parent.getBackground());
        topComposite.setBackgroundMode(1);
        topComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)topComposite);
        this.sortAndOrderAttributes();
        if (!this.rightColumnAttributes.isEmpty()) {
            SashForm topSash = new SashForm(topComposite, 256);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)topSash);
            topSash.setSashWidth(4);
            this.leftColumnComposite = new Composite((Composite)topSash, 0);
            this.rightColumnComposite = new Composite((Composite)topSash, 0);
            GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).extendedMargins(5, 2, 5, 5).applyTo(this.rightColumnComposite);
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.rightColumnComposite);
            int[] topWeights = new int[]{50, 50};
            topSash.setWeights(topWeights);
        } else {
            this.leftColumnComposite = new Composite(topComposite, 0);
        }
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).extendedMargins(2, 5, 5, 5).applyTo(this.leftColumnComposite);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.leftColumnComposite);
        this.bottomComposite = new Composite(topComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).extendedMargins(0, 0, 0, 0).applyTo(this.bottomComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.bottomComposite);
        this.createAttributes(this.leftColumnComposite, this.leftColumnAttributes);
        if (!this.rightColumnAttributes.isEmpty()) {
            this.createAttributes(this.rightColumnComposite, this.rightColumnAttributes);
        }
        this.createAttributes(this.bottomComposite, this.bottomAttributes);
        this.updateLiveValidation();
        return topComposite;
    }

    private void filterHiddenAttributes(Collection<IItemPropertyDescriptor> propertyDescriptors) {
        Iterator<IItemPropertyDescriptor> iterator = propertyDescriptors.iterator();
        AnnotationHiddenDescriptor visibilityDescriptor = new AnnotationHiddenDescriptor();
        while (iterator.hasNext()) {
            IItemPropertyDescriptor descriptor = iterator.next();
            if (!((Boolean)visibilityDescriptor.getValue(descriptor, this.modelElementContext.getModelElement())).booleanValue()) continue;
            iterator.remove();
        }
    }

    private void sortAndOrderAttributes() {
        this.composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{this.composedAdapterFactory, new ReflectiveItemProviderAdapterFactory()});
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        List propertyDescriptors = adapterFactoryItemDelegator.getPropertyDescriptors((Object)this.modelElementContext.getModelElement());
        if (propertyDescriptors != null) {
            this.filterHiddenAttributes(propertyDescriptors);
            AnnotationPositionDescriptor positionDescriptor = new AnnotationPositionDescriptor();
            for (IItemPropertyDescriptor itemPropertyDescriptor : propertyDescriptors) {
                String value = (String)positionDescriptor.getValue(itemPropertyDescriptor, this.modelElementContext.getModelElement());
                if (value.equals("left")) {
                    this.leftColumnAttributes.add(itemPropertyDescriptor);
                    continue;
                }
                if (value.equals("right")) {
                    this.rightColumnAttributes.add(itemPropertyDescriptor);
                    continue;
                }
                if (value.equals("bottom")) {
                    this.bottomAttributes.add(itemPropertyDescriptor);
                    continue;
                }
                this.leftColumnAttributes.add(itemPropertyDescriptor);
            }
            HashMap<IItemPropertyDescriptor, Double> priorityMap = new HashMap<IItemPropertyDescriptor, Double>();
            AnnotationPriorityDescriptor priorityDescriptor = new AnnotationPriorityDescriptor();
            for (IItemPropertyDescriptor itemPropertyDescriptor : propertyDescriptors) {
                priorityMap.put(itemPropertyDescriptor, (Double)priorityDescriptor.getValue(itemPropertyDescriptor, this.modelElementContext.getModelElement()));
            }
            Comparator<IItemPropertyDescriptor> comparator = new Comparator<IItemPropertyDescriptor>(){

                @Override
                public int compare(IItemPropertyDescriptor o1, IItemPropertyDescriptor o2) {
                    return Double.compare((Double)priorityMap.get(o1), (Double)priorityMap.get(o2));
                }
            };
            Collections.sort(this.leftColumnAttributes, comparator);
            Collections.sort(this.rightColumnAttributes, comparator);
            Collections.sort(this.bottomAttributes, comparator);
        }
    }

    private void createAttributes(Composite column, List<IItemPropertyDescriptor> attributes) {
        Composite attributeComposite = new Composite(column, 0);
        attributeComposite.setBackgroundMode(1);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(attributeComposite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 1).indent(10, 0).applyTo((Control)attributeComposite);
        ECPControlFactory controlFactory = Activator.getDefault().getECPControlFactory();
        if (controlFactory == null) {
            Activator.getDefault().ungetECPControlFactory();
            return;
        }
        for (IItemPropertyDescriptor itemPropertyDescriptor : attributes) {
            SWTControl control = (SWTControl)controlFactory.createControl(SWTControl.class, itemPropertyDescriptor, this.modelElementContext);
            if (control == null) continue;
            int numColumnSpan = 2;
            if (control.showLabel()) {
                Label label = new Label(attributeComposite, 0);
                label.setText(itemPropertyDescriptor.getDisplayName((Object)this.modelElementContext.getModelElement()));
                label.setToolTipText(itemPropertyDescriptor.getDescription((Object)this.modelElementContext.getModelElement()));
                GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)label);
                --numColumnSpan;
            }
            Composite composite = control.createControl(attributeComposite);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(numColumnSpan, 1).applyTo((Control)composite);
            this.meControls.put((EStructuralFeature)itemPropertyDescriptor.getFeature((Object)this.modelElementContext.getModelElement()), (ECPAbstractControl)control);
            Activator.getDefault().ungetECPControlFactory();
        }
    }

    @Override
    public void dispose() {
        for (ECPAbstractControl control : this.meControls.values()) {
            control.dispose();
        }
        this.meControls.clear();
        this.modelElementChangeListener.remove();
        this.composedAdapterFactory.dispose();
    }

    @Override
    public void updateLiveValidation() {
        ECPAbstractControl meControl;
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(this.modelElementContext.getModelElement());
        ArrayList<ECPAbstractControl> affectedControls = new ArrayList<ECPAbstractControl>();
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            EObject eObject;
            Object object = childDiagnostic.getData().get(0);
            if (object instanceof EObject && (eObject = (EObject)object) != this.modelElementContext.getModelElement() || childDiagnostic.getData().size() < 2 || (meControl = this.meControls.get(childDiagnostic.getData().get(1))) == null) continue;
            affectedControls.add(meControl);
            if (this.valdiatedControls.containsKey(meControl)) {
                if (childDiagnostic.getSeverity() == this.valdiatedControls.get(meControl).getSeverity()) continue;
                meControl.handleValidation(childDiagnostic);
                this.valdiatedControls.put(meControl, childDiagnostic);
                continue;
            }
            meControl.handleValidation(childDiagnostic);
            this.valdiatedControls.put(meControl, childDiagnostic);
        }
        HashMap<ECPAbstractControl, Diagnostic> temp = new HashMap<ECPAbstractControl, Diagnostic>();
        temp.putAll(this.valdiatedControls);
        for (Map.Entry entry : temp.entrySet()) {
            meControl = (ECPAbstractControl)entry.getKey();
            if (affectedControls.contains(meControl)) continue;
            this.valdiatedControls.remove(meControl);
            meControl.resetValidation();
        }
    }

    @Override
    public void focus() {
        this.leftColumnComposite.setFocus();
    }
}

