/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.ECPControlContext;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTControl;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public abstract class SingleControl
extends SWTControl {
    private static final String VALIDATION_ERROR_ICON = "icons/validation_error.png";

    public SingleControl(boolean showLabel, IItemPropertyDescriptor itemPropertyDescriptor, EStructuralFeature feature, ECPControlContext modelElementContext, boolean embedded) {
        super(showLabel, itemPropertyDescriptor, feature, modelElementContext, embedded);
    }

    public void handleValidation(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 4 || diagnostic.getSeverity() == 2) {
            Image image = Activator.getImage(VALIDATION_ERROR_ICON);
            this.validationLabel.setImage(image);
            Diagnostic reason = diagnostic;
            if (diagnostic.getChildren() != null && diagnostic.getChildren().size() != 0) {
                reason = (Diagnostic)diagnostic.getChildren().get(0);
            }
            this.validationLabel.setToolTipText(reason.getMessage());
            this.updateValidationColor(this.validationLabel.getShell().getDisplay().getSystemColor(3));
        } else {
            this.resetValidation();
        }
    }

    protected void updateValidationColor(Color color) {
    }

    public void resetValidation() {
        if (this.validationLabel == null || this.validationLabel.isDisposed()) {
            return;
        }
        this.validationLabel.setImage(null);
        this.validationLabel.setToolTipText("");
        this.updateValidationColor(null);
    }

    public void dispose() {
        this.validationLabel.dispose();
    }
}

