/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.composites;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.ui.model.ProvidersContentProvider;
import org.eclipse.emf.ecp.internal.ui.model.ProvidersLabelProvider;
import org.eclipse.emf.ecp.spi.ui.UIProvider;
import org.eclipse.emf.ecp.spi.ui.UIProviderRegistry;
import org.eclipse.emf.ecp.ui.common.AddRepositoryComposite;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddRepositoryCompositeImpl
implements AddRepositoryComposite {
    private Composite providerStack;
    private StackLayout providerStackLayout;
    private Text repositoryDescriptionText;
    private Text repositoryNameText;
    private AddRepositoryComposite.AddRepositoryChangeListener listener;
    private ECPProvider provider;
    private String repositoryName;
    private String repositoryDescription;
    private Map<String, Control> providerControls = new HashMap<String, Control>();
    private Map<String, ECPProperties> providerProperties = new HashMap<String, ECPProperties>();

    public AddRepositoryCompositeImpl(ECPProvider provider) {
        this.provider = provider;
    }

    public Composite createUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        if (this.provider == null) {
            this.createProviderSelector(composite);
        }
        GridData gdProviderStack = new GridData(4, 4, true, true, 2, 1);
        this.providerStackLayout = new StackLayout();
        this.providerStack = new Composite(composite, 0);
        this.providerStack.setLayout((Layout)this.providerStackLayout);
        this.providerStack.setLayoutData((Object)gdProviderStack);
        Label repositoryNameLabel = new Label(composite, 0);
        repositoryNameLabel.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        repositoryNameLabel.setText(Messages.AddRepositoryComposite_RepositoryName);
        this.repositoryNameText = new Text(composite, 2048);
        this.repositoryNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.repositoryNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddRepositoryCompositeImpl.this.repositoryName = AddRepositoryCompositeImpl.this.repositoryNameText.getText();
                if (AddRepositoryCompositeImpl.this.listener != null) {
                    AddRepositoryCompositeImpl.this.listener.repositoryNameChanged(AddRepositoryCompositeImpl.this.repositoryName);
                }
            }
        });
        Label repositoryDescriptionLabel = new Label(composite, 0);
        repositoryDescriptionLabel.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        repositoryDescriptionLabel.setText(Messages.AddRepositoryComposite_RepositoryDescription);
        this.repositoryDescriptionText = new Text(composite, 2048);
        GridData gdRepositoryDescriptionText = new GridData(4, 0x1000000, true, false, 1, 1);
        gdRepositoryDescriptionText.heightHint = 36;
        this.repositoryDescriptionText.setLayoutData((Object)gdRepositoryDescriptionText);
        this.repositoryDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddRepositoryCompositeImpl.this.repositoryDescription = AddRepositoryCompositeImpl.this.repositoryDescriptionText.getText();
                if (AddRepositoryCompositeImpl.this.listener != null) {
                    AddRepositoryCompositeImpl.this.listener.repositoryDescriptionChanged(AddRepositoryCompositeImpl.this.repositoryDescription);
                }
            }
        });
        if (this.provider != null) {
            this.showProviderUI(this.provider);
        }
        return composite;
    }

    private void createProviderSelector(Composite composite) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        label.setText(Messages.AddRepositoryComposite_RepositoryProvider);
        ComboViewer providersViewer = new ComboViewer(composite, 0);
        Combo combo = providersViewer.getCombo();
        GridData gdCombo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdCombo.widthHint = 150;
        combo.setLayoutData((Object)gdCombo);
        providersViewer.setContentProvider((IContentProvider)new ProvidersContentProvider(true));
        providersViewer.setLabelProvider((IBaseLabelProvider)new ProvidersLabelProvider());
        providersViewer.setSorter(new ViewerSorter());
        providersViewer.setInput((Object)ECPUtil.getECPProviderRegistry());
        providersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                AddRepositoryCompositeImpl.this.provider = (ECPProvider)selection.getFirstElement();
                if (AddRepositoryCompositeImpl.this.provider != null) {
                    AddRepositoryCompositeImpl.this.showProviderUI(AddRepositoryCompositeImpl.this.provider);
                    if (AddRepositoryCompositeImpl.this.listener != null) {
                        AddRepositoryCompositeImpl.this.listener.repositoryProviderChanged(AddRepositoryCompositeImpl.this.provider);
                    }
                }
            }
        });
        for (ECPProvider provider : ECPUtil.getECPProviderRegistry().getProviders()) {
            if (!provider.hasCreateRepositorySupport()) continue;
            providersViewer.setSelection((ISelection)new StructuredSelection((Object)provider));
            break;
        }
    }

    private void showProviderUI(ECPProvider provider) {
        if (this.providerStack == null) {
            return;
        }
        String name = provider.getName();
        Control control = this.providerControls.get(name);
        if (control == null) {
            ECPProperties properties = ECPUtil.createProperties();
            UIProvider uiProvider = UIProviderRegistry.INSTANCE.getUIProvider(name);
            control = uiProvider.createAddRepositoryUI(this.providerStack, properties, this.repositoryNameText, this.repositoryNameText, this.repositoryDescriptionText);
            this.providerControls.put(name, control);
            this.providerProperties.put(name, properties);
        }
        this.providerStackLayout.topControl = control;
        this.providerStack.layout();
    }

    public ECPProvider getProvider() {
        return this.provider;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryDescription() {
        return this.repositoryDescription;
    }

    public ECPProperties getProperties() {
        if (this.provider == null) {
            return null;
        }
        return this.providerProperties.get(this.provider.getName());
    }

    public String getRepositoryLabel() {
        return this.repositoryName;
    }

    public void setListener(AddRepositoryComposite.AddRepositoryChangeListener listener) {
        this.listener = listener;
    }

    public void dispose() {
    }
}

