/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.exceptions.ECPProjectWithNameExistsException;
import org.eclipse.emf.ecp.core.util.ECPCheckoutSource;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.ui.dialogs.DeleteDialog;
import org.eclipse.emf.ecp.internal.ui.dialogs.ProjectPropertiesDialog;
import org.eclipse.emf.ecp.internal.ui.dialogs.RepositoryPropertiesDialog;
import org.eclipse.emf.ecp.internal.wizards.AddRepositoryWizard;
import org.eclipse.emf.ecp.internal.wizards.CheckoutProjectWizard;
import org.eclipse.emf.ecp.internal.wizards.CreateProjectWizard;
import org.eclipse.emf.ecp.internal.wizards.FilterModelElementWizard;
import org.eclipse.emf.ecp.internal.wizards.SelectModelElementWizard;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.ui.common.AddRepositoryComposite;
import org.eclipse.emf.ecp.ui.common.CheckedModelClassComposite;
import org.eclipse.emf.ecp.ui.common.CheckoutProjectComposite;
import org.eclipse.emf.ecp.ui.common.CompositeFactory;
import org.eclipse.emf.ecp.ui.common.CreateProjectComposite;
import org.eclipse.emf.ecp.ui.common.SelectionComposite;
import org.eclipse.emf.ecp.ui.util.ECPModelElementOpenTester;
import org.eclipse.emf.ecp.ui.util.ECPModelElementOpener;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ECPHandlerHelper {
    private ECPHandlerHelper() {
    }

    private static void showError(Shell shell, String title, String message) {
        MessageDialog.openError((Shell)shell, (String)title, (String)message);
    }

    public static void checkout(List<ECPCheckoutSource> checkoutObjects, Shell shell) {
        for (ECPCheckoutSource checkoutSource : checkoutObjects) {
            CheckoutProjectComposite checkoutCompposite = CompositeFactory.getCheckoutProjectComposite(checkoutSource);
            CheckoutProjectWizard wizard = new CheckoutProjectWizard();
            wizard.setCompositeProvider(checkoutCompposite);
            WizardDialog wd = new WizardDialog(shell, (IWizard)wizard);
            int result = wd.open();
            if (result != 0) continue;
            String projectName = checkoutCompposite.getProjectName();
            ECPProperties projectProperties = checkoutCompposite.getProjectProperties();
            try {
                checkoutSource.checkout(projectName, projectProperties);
            }
            catch (ECPProjectWithNameExistsException eCPProjectWithNameExistsException) {
                ECPHandlerHelper.showError(shell, "Cannot checkout project", "A project with name " + projectName + " already exists in the workspace.");
            }
        }
    }

    public static void deleteModelElement(ECPProject project, Collection<Object> objects) {
        if (project != null) {
            project.deleteElements(objects);
        }
    }

    public static ECPProject createProject(Shell shell) {
        ArrayList<ECPProvider> providers = new ArrayList<ECPProvider>();
        for (ECPProvider provider : ECPUtil.getECPProviderRegistry().getProviders()) {
            if (!provider.hasCreateProjectWithoutRepositorySupport()) continue;
            providers.add(provider);
        }
        if (providers.size() == 0) {
            ECPHandlerHelper.showError(shell, "No Provider", "Please check if a suitable provider is installed.");
            return null;
        }
        CreateProjectComposite createProjectComposite = CompositeFactory.getCreateProjectComposite(providers);
        CreateProjectWizard wizard = new CreateProjectWizard();
        wizard.setCompositeProvider(createProjectComposite);
        WizardDialog wd = new WizardDialog(shell, (IWizard)wizard);
        int result = wd.open();
        if (result == 0) {
            ECPProvider selectedProvider = createProjectComposite.getProvider();
            if (selectedProvider == null) {
                ECPHandlerHelper.showError(shell, "No project created", "Please check if a suitable provider is installed.");
                return null;
            }
            ECPProperties projectProperties = createProjectComposite.getProperties();
            String projectName = createProjectComposite.getProjectName();
            ECPProject project = null;
            try {
                project = ECPUtil.getECPProjectManager().createProject(selectedProvider, projectName, projectProperties);
            }
            catch (ECPProjectWithNameExistsException eCPProjectWithNameExistsException) {
                ECPHandlerHelper.showError(shell, "No project created", "A project with name " + projectName + " already exists in the workspace.");
                return null;
            }
            if (project == null) {
                ECPHandlerHelper.showError(shell, "No project created", "Please check the log.");
                return null;
            }
            ((InternalProvider)selectedProvider).handleLifecycle((ECPContainer)project, InternalProvider.LifecycleEvent.CREATE);
            project.open();
            return project;
        }
        return null;
    }

    public static EObject addModelElement(final ECPProject ecpProject, Shell shell, boolean open) {
        SelectionComposite<TreeViewer> helper = CompositeFactory.getSelectModelClassComposite(ecpProject);
        SelectModelElementWizard wizard = new SelectModelElementWizard(Messages.NewModelElementWizardHandler_Title, Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.NewModelElementWizard_PageTitle_AddModelElement, Messages.NewModelElementWizard_PageDescription_AddModelElement);
        wizard.setCompositeProvider(helper);
        WizardDialog wd = new WizardDialog(shell, (IWizard)wizard);
        int wizardResult = wd.open();
        if (wizardResult == 0) {
            Object[] selection = helper.getSelection();
            if (selection == null || selection.length == 0) {
                return null;
            }
            EClass newMEType = (EClass)selection[0];
            if (ecpProject != null && newMEType != null) {
                EPackage ePackage = newMEType.getEPackage();
                final EObject newMEInstance = ePackage.getEFactoryInstance().create(newMEType);
                ecpProject.getEditingDomain().getCommandStack().execute((Command)new ChangeCommand((Notifier)newMEInstance){

                    protected void doExecute() {
                        ecpProject.getContents().add((Object)newMEInstance);
                    }
                });
                if (open) {
                    ECPHandlerHelper.openModelElement(newMEInstance, ecpProject);
                }
                return newMEInstance;
            }
        }
        return null;
    }

    public static void filterProjectPackages(ECPProject ecpProject, Shell shell) {
        Set ePackages = ECPUtil.getAllRegisteredEPackages();
        CheckedModelClassComposite checkedModelComposite = CompositeFactory.getCheckedModelClassComposite(ePackages);
        HashSet initialSelectionSet = new HashSet();
        initialSelectionSet.addAll(((InternalProject)ecpProject).getVisiblePackages());
        initialSelectionSet.addAll(((InternalProject)ecpProject).getVisibleEClasses());
        checkedModelComposite.setInitialSelection(initialSelectionSet.toArray());
        FilterModelElementWizard wizard = new FilterModelElementWizard();
        wizard.setCompositeProvider(checkedModelComposite);
        WizardDialog wd = new WizardDialog(shell, (IWizard)wizard);
        int wizardResult = wd.open();
        if (wizardResult == 0) {
            Object[] dialogSelection = checkedModelComposite.getChecked();
            HashSet<EPackage> filtererdPackages = new HashSet<EPackage>();
            HashSet<EClass> filtererdEClasses = new HashSet<EClass>();
            Object[] objectArray = dialogSelection;
            int n = dialogSelection.length;
            int n2 = 0;
            while (n2 < n) {
                EClass eClass;
                Object object = objectArray[n2];
                if (object instanceof EPackage) {
                    filtererdPackages.add((EPackage)object);
                } else if (object instanceof EClass && !filtererdPackages.contains((eClass = (EClass)object).getEPackage())) {
                    filtererdEClasses.add(eClass);
                }
                ++n2;
            }
            ((InternalProject)ecpProject).setVisiblePackages(filtererdPackages);
            ((InternalProject)ecpProject).setVisibleEClasses(filtererdEClasses);
        }
    }

    public static ECPRepository createRepository(Shell shell) {
        AddRepositoryComposite addRepositoryComposite = CompositeFactory.getAddRepositoryComposite();
        AddRepositoryWizard wizard = new AddRepositoryWizard();
        wizard.setCompositeProvider(addRepositoryComposite);
        WizardDialog wd = new WizardDialog(shell, (IWizard)wizard);
        int wizardResult = wd.open();
        if (wizardResult == 0) {
            ECPRepository ecpRepository = ECPUtil.getECPRepositoryManager().addRepository(addRepositoryComposite.getProvider(), addRepositoryComposite.getRepositoryName(), addRepositoryComposite.getRepositoryLabel() == null ? "" : addRepositoryComposite.getRepositoryLabel(), addRepositoryComposite.getRepositoryDescription() == null ? "" : addRepositoryComposite.getRepositoryDescription(), addRepositoryComposite.getProperties());
            return ecpRepository;
        }
        return null;
    }

    public static void changeCloseState(ECPProject[] closeables, String currentType) {
        ECPProject[] eCPProjectArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            ECPProject closeable = eCPProjectArray[n2];
            if ("open".equalsIgnoreCase(currentType)) {
                closeable.open();
            } else if ("close".equalsIgnoreCase(currentType)) {
                closeable.close();
            }
            ++n2;
        }
    }

    public static void deleteHandlerHelper(List<ECPContainer> deletables, Shell shell) {
        DeleteDialog dialog;
        if (!deletables.isEmpty() && (dialog = new DeleteDialog(shell, deletables)).open() == 0) {
            for (ECPContainer deletable : deletables) {
                deletable.delete();
            }
        }
    }

    public static void saveProject(ECPProject project) {
        project.saveContents();
    }

    public static void openModelElement(Object me, ECPProject ecpProject) {
        if (me == null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ActionHelper_ErrorTitle_ElementDeleted, (String)Messages.ActionHelper_ErrorMessage_ElementDeleted);
            return;
        }
        IConfigurationElement[] modelelementopener = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.ui.modelElementOpener");
        ECPModelElementOpener bestCandidate = null;
        int bestValue = -1;
        IConfigurationElement[] iConfigurationElementArray = modelelementopener;
        int n = modelelementopener.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            modelelementopener = null;
            try {
                ECPModelElementOpener modelelementOpener = (ECPModelElementOpener)element.createExecutableExtension("class");
                IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    ECPModelElementOpenTester tester;
                    int value;
                    IConfigurationElement testerElement = iConfigurationElementArray2[n4];
                    if ("staticTester".equals(testerElement.getName())) {
                        int priority = Integer.parseInt(testerElement.getAttribute("priority"));
                        String type = testerElement.getAttribute("modelElement");
                        try {
                            Class supportedClassType = ECPHandlerHelper.loadClass(testerElement.getContributor().getName(), type);
                            if (supportedClassType.isInstance(me) && priority > bestValue) {
                                bestCandidate = modelelementOpener;
                                bestValue = priority;
                            }
                        }
                        catch (ClassNotFoundException ex) {
                            Activator.log(ex);
                        }
                    } else if ("dynamicTester".equals(testerElement.getName()) && (value = (tester = (ECPModelElementOpenTester)testerElement.createExecutableExtension("tester")).isApplicable(me)) > bestValue) {
                        bestCandidate = modelelementOpener;
                        bestValue = value;
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
            ++n2;
        }
        try {
            bestCandidate.openModelElement(me, ecpProject);
        }
        catch (RuntimeException e) {
            Activator.log(e);
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + " cannot be loaded because bundle " + bundleName + " cannot be resolved");
        }
        return bundle.loadClass(clazz);
    }

    public static void openProjectProperties(ECPProject project, boolean editable, Shell shell) {
        new ProjectPropertiesDialog(shell, editable, project).open();
    }

    public static void openRepositoryProperties(ECPRepository repository, boolean editable, Shell shell) {
        new RepositoryPropertiesDialog(shell, editable, repository).open();
    }
}

