/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.ECPRepositoryManager;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPRepositoryAware;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProvidersChangedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPRepositoriesChangedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPRepositoryContentChangedObserver;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.internal.core.ECPRepositoryImpl;
import org.eclipse.emf.ecp.internal.core.util.ExtensionParser;
import org.eclipse.emf.ecp.internal.core.util.InternalUtil;
import org.eclipse.emf.ecp.internal.core.util.PropertiesStore;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.net4j.util.AdapterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ECPRepositoryManagerImpl
extends PropertiesStore<InternalRepository, ECPObserver>
implements ECPRepositoryManager,
ECPProvidersChangedObserver {
    public static ECPRepositoryManagerImpl INSTANCE;
    private final RepositoryParser extensionParser = new RepositoryParser();

    public ECPRepositoryManagerImpl() {
        INSTANCE = this;
    }

    protected void startup() {
        this.setFolder(new File(Activator.getInstance().getStateLocation().toFile(), "repositories"));
        this.activate();
    }

    @Override
    public InternalRepository getRepository(Object adaptable) {
        if (adaptable instanceof ECPRepositoryAware) {
            ECPRepositoryAware repositoryAware = (ECPRepositoryAware)adaptable;
            return (InternalRepository)repositoryAware.getRepository();
        }
        return (InternalRepository)AdapterUtil.adapt((Object)adaptable, InternalRepository.class);
    }

    @Override
    public InternalRepository getRepository(String name) {
        return (InternalRepository)this.getElement(name);
    }

    @Override
    public Collection<ECPRepository> getRepositories() {
        return this.getElements();
    }

    public boolean hasRepositories() {
        return this.hasElements();
    }

    @Override
    public ECPRepository addRepository(ECPProvider provider, String name, String label, String description, ECPProperties properties) {
        if (!provider.hasCreateRepositorySupport()) {
            throw new UnsupportedOperationException("The provider " + provider.getLabel() + " doesn't support the addition of new repositories.");
        }
        ECPRepositoryImpl repository = new ECPRepositoryImpl(provider, name, properties);
        repository.setLabel(label);
        repository.setDescription(description);
        ((InternalProvider)provider).handleLifecycle(repository, InternalProvider.LifecycleEvent.CREATE);
        this.changeElements(null, Collections.singleton(repository));
        return repository;
    }

    public void notifyObjectsChanged(ECPRepository repository, Collection<Object> objects) {
        try {
            ECPUtil.getECPObserverBus().notify(ECPRepositoryContentChangedObserver.class).contentChanged(repository, objects);
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    @Override
    public void providersChanged(Collection<ECPProvider> oldProviders, Collection<ECPProvider> newProviders) {
        Set<ECPProvider> addedProviders = InternalUtil.getAddedElements(oldProviders, newProviders);
        if (!addedProviders.isEmpty()) {
            this.load();
        }
    }

    @Override
    protected InternalRepository loadElement(ObjectInput in) throws IOException {
        return new ECPRepositoryImpl(in);
    }

    @Override
    protected void notifyObservers(Collection<InternalRepository> oldRepositories, Collection<InternalRepository> newRepositories) throws Exception {
        ECPUtil.getECPObserverBus().notify(ECPRepositoriesChangedObserver.class).repositoriesChanged(oldRepositories, newRepositories);
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        this.extensionParser.activate();
        ECPUtil.getECPObserverBus().register(this);
    }

    protected void doDeactivate() throws Exception {
        ECPUtil.getECPObserverBus().unregister(this);
        this.extensionParser.deactivate();
        super.doDeactivate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RepositoryDescriptor
    extends ExtensionParser.ExtensionDescriptor<InternalRepository>
    implements InternalRepository {
        private ECPProperties properties;

        public RepositoryDescriptor(String name, IConfigurationElement configurationElement) {
            super(ECPRepositoryManagerImpl.this, name, "Repository", configurationElement);
            this.properties = ECPUtil.createProperties();
            IConfigurationElement[] iConfigurationElementArray = configurationElement.getChildren("property");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement property = iConfigurationElementArray[n2];
                String key = property.getAttribute("key");
                String value = property.getAttribute("value");
                this.properties.addProperty(key, value);
                ++n2;
            }
        }

        @Override
        public boolean isStorable() {
            return false;
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public InternalProvider getProvider() {
            String providerName = this.getConfigurationElement().getAttribute("provider");
            return (InternalProvider)ECPUtil.getECPProviderRegistry().getProvider(providerName);
        }

        @Override
        public ECPProperties getProperties() {
            return this.properties;
        }

        @Override
        public Object getProviderSpecificData() {
            return ((InternalRepository)this.getResolvedElement()).getProviderSpecificData();
        }

        @Override
        public void setProviderSpecificData(Object data) {
            ((InternalRepository)this.getResolvedElement()).setProviderSpecificData(data);
        }

        public ECPContainer getContext() {
            return this;
        }

        @Override
        public boolean canDelete() {
            return false;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void notifyObjectsChanged(Collection<Object> objects) {
            ((InternalRepository)this.getResolvedElement()).notifyObjectsChanged(objects);
        }

        @Override
        protected InternalRepository resolve() throws Exception {
            return new ECPRepositoryImpl(this.getProvider(), this.getName(), this.getProperties());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RepositoryParser
    extends ExtensionParser<InternalRepository> {
        private static final String EXTENSION_POINT_NAME = "repositories";

        public RepositoryParser() {
            super(ECPRepositoryManagerImpl.this, "org.eclipse.emf.ecp.core", EXTENSION_POINT_NAME);
        }

        @Override
        protected InternalRepository createElement(String name, IConfigurationElement configurationElement) {
            RepositoryDescriptor descriptor = new RepositoryDescriptor(name, configurationElement);
            descriptor.setLabel(configurationElement.getDeclaringExtension().getLabel());
            descriptor.setDescription(configurationElement.getAttribute("description"));
            return descriptor;
        }
    }
}

