/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import java.net.URL;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.ECPControlContext;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.actions.AddReferenceAction;
import org.eclipse.emf.ecp.edit.internal.swt.actions.DeleteReferenceAction;
import org.eclipse.emf.ecp.edit.internal.swt.actions.NewReferenceAction;
import org.eclipse.emf.ecp.edit.internal.swt.controls.SingleControl;
import org.eclipse.emf.ecp.edit.util.ECPModelElementChangeListener;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class LinkControl
extends SingleControl {
    private Composite linkComposite;
    private Link hyperlink;
    private Label imageHyperlink;
    protected ComposedAdapterFactory composedAdapterFactory;
    private ECPModelElementChangeListener modelElementChangeListener;
    private Label unsetLabel;
    private StackLayout stackLayout;
    private Composite mainComposite;
    private Button[] buttons;
    protected AdapterFactoryItemDelegator adapterFactoryItemDelegator;

    public LinkControl(boolean showLabel, IItemPropertyDescriptor itemPropertyDescriptor, EStructuralFeature feature, ECPControlContext modelElementContext, boolean embedded) {
        super(showLabel, itemPropertyDescriptor, feature, modelElementContext, embedded);
    }

    protected void fillControlComposite(Composite composite) {
        int numColumns = 1 + this.getNumButtons();
        if (this.isEmbedded()) {
            numColumns = 1;
        }
        if (!this.isEmbedded() && this.getStructuralFeature().isUnsettable()) {
            ++numColumns;
        }
        GridLayoutFactory.fillDefaults().numColumns(numColumns).spacing(0, 0).equalWidth(false).applyTo(composite);
        this.mainComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.mainComposite);
        this.stackLayout = new StackLayout();
        this.mainComposite.setLayout((Layout)this.stackLayout);
        this.unsetLabel = new Label(this.mainComposite, 0);
        this.unsetLabel.setText("(Not Set)");
        this.unsetLabel.setBackground(composite.getBackground());
        this.unsetLabel.setForeground(composite.getShell().getDisplay().getSystemColor(16));
        this.unsetLabel.setAlignment(0x1000000);
        this.linkComposite = new Composite(this.mainComposite, 0);
        this.linkComposite.setLayout((Layout)new GridLayout(2, false));
        this.createHyperlink();
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.linkComposite);
        this.stackLayout.topControl = this.getModelElementContext().getModelElement().eIsSet(this.getStructuralFeature()) ? this.linkComposite : this.unsetLabel;
        if (!this.isEmbedded()) {
            this.buttons = this.createButtons(composite);
        }
    }

    protected int getNumButtons() {
        return 3;
    }

    protected Button[] createButtons(Composite composite) {
        Button[] buttons = new Button[]{this.createButtonForAction(new DeleteReferenceAction(this.getModelElementContext(), this.getItemPropertyDescriptor(), this.getStructuralFeature()), composite), this.createButtonForAction(new AddReferenceAction(this.getModelElementContext(), this.getItemPropertyDescriptor(), this.getStructuralFeature()), composite), this.createButtonForAction(new NewReferenceAction(this.getModelElementContext(), this.getItemPropertyDescriptor(), this.getStructuralFeature()), composite)};
        return buttons;
    }

    private void createHyperlink() {
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        this.imageHyperlink = new Label(this.linkComposite, 0);
        this.hyperlink = new Link(this.linkComposite, 0);
        this.hyperlink.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_reference");
        this.hyperlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                super.widgetDefaultSelected(e);
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LinkControl.this.linkClicked((EObject)LinkControl.this.getModelValue().getValue());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.hyperlink);
    }

    protected void linkClicked(EObject value) {
        this.getModelElementContext().openInNewContext(value);
    }

    public void setEditable(boolean isEditable) {
        if (!this.isEmbedded()) {
            Button[] buttonArray = this.buttons;
            int n = this.buttons.length;
            int n2 = 0;
            while (n2 < n) {
                Button button = buttonArray[n2];
                button.setVisible(isEditable);
                ++n2;
            }
        }
        this.mainComposite.getParent().layout();
    }

    public Binding bindValue() {
        ISWTObservableValue value = SWTObservables.observeText((Control)this.hyperlink);
        this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), new UpdateValueStrategy(){

            public Object convert(Object value) {
                return LinkControl.this.getModelValue().getValue();
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                LinkControl.this.updateChangeListener((EObject)value);
                return "<a>" + LinkControl.this.getLinkText(value) + "</a>";
            }
        });
        ISWTObservableValue tooltipValue = SWTObservables.observeTooltipText((Control)this.hyperlink);
        this.getDataBindingContext().bindValue((IObservableValue)tooltipValue, this.getModelValue(), new UpdateValueStrategy(){

            public Object convert(Object value) {
                return LinkControl.this.getModelValue().getValue();
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                return LinkControl.this.getLinkText(value);
            }
        });
        ISWTObservableValue imageValue = SWTObservables.observeImage((Widget)this.imageHyperlink);
        this.getDataBindingContext().bindValue((IObservableValue)imageValue, this.getModelValue(), new UpdateValueStrategy(){

            public Object convert(Object value) {
                return LinkControl.this.getModelValue().getValue();
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                return LinkControl.this.getImage(value);
            }
        });
        return null;
    }

    protected Object getImage(Object value) {
        return Activator.getImage((URL)this.adapterFactoryItemDelegator.getImage(value));
    }

    protected Object getLinkText(Object value) {
        String linkName = this.adapterFactoryItemDelegator.getText(value);
        return linkName == null ? "" : linkName;
    }

    private void updateChangeListener(EObject value) {
        if (this.modelElementChangeListener != null) {
            if (this.modelElementChangeListener.getTarget().equals(value)) {
                return;
            }
            this.modelElementChangeListener.remove();
            this.modelElementChangeListener = null;
        }
        if (value == null) {
            if (this.stackLayout.topControl != this.unsetLabel) {
                this.stackLayout.topControl = this.unsetLabel;
                this.mainComposite.layout();
            }
        } else {
            if (this.stackLayout.topControl != this.linkComposite) {
                this.stackLayout.topControl = this.linkComposite;
                this.mainComposite.layout();
            }
            this.modelElementChangeListener = new ECPModelElementChangeListener(value){

                public void onChange(Notification notification) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            LinkControl.this.getDataBindingContext().updateTargets();
                            LinkControl.this.linkComposite.layout();
                        }
                    });
                }
            };
        }
    }

    public void dispose() {
        this.composedAdapterFactory.dispose();
        if (this.modelElementChangeListener != null) {
            this.modelElementChangeListener.remove();
        }
        this.hyperlink.dispose();
        super.dispose();
    }

    protected String getUnsetLabelText() {
        return "No link set! Click to set link.";
    }

    protected String getUnsetButtonTooltip() {
        return "Unset Link";
    }

    protected Control[] getControlsForTooltip() {
        return new Control[]{this.hyperlink, this.imageHyperlink};
    }
}

