/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.ECPControlContext;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.controls.AbstractTextControl;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericalControl
extends AbstractTextControl {
    public NumericalControl(boolean showLabel, IItemPropertyDescriptor itemPropertyDescriptor, EStructuralFeature feature, ECPControlContext modelElementContext, boolean embedded) {
        super(showLabel, itemPropertyDescriptor, feature, modelElementContext, embedded);
    }

    @Override
    protected int getTextWidgetStyle() {
        return super.getTextWidgetStyle() | 0x20000;
    }

    @Override
    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_numerical";
    }

    @Override
    protected String getUnsetLabelText() {
        return "No number set! Click to set number.";
    }

    @Override
    protected String getUnsetButtonTooltip() {
        return "Unset number";
    }

    @Override
    protected void customizeText(Text text) {
        super.customizeText(text);
        text.setMessage(this.getFormatText());
    }

    @Override
    public Binding bindValue() {
        ISWTObservableValue value = SWTObservables.observeText((Control)this.getText(), (int)16);
        NumericalTargetToModelUpdateStrategy targetToModelStrategy = new NumericalTargetToModelUpdateStrategy();
        NumericalModelToTargetUpdateStrategy modelToTargetStrategy = new NumericalModelToTargetUpdateStrategy();
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), (UpdateValueStrategy)targetToModelStrategy, (UpdateValueStrategy)modelToTargetStrategy);
        if (this.isEmbedded()) {
            value.addValueChangeListener(new IValueChangeListener((IObservableValue)value, binding, targetToModelStrategy){
                private final /* synthetic */ IObservableValue val$value;
                private final /* synthetic */ Binding val$binding;
                private final /* synthetic */ NumericalTargetToModelUpdateStrategy val$targetToModelStrategy;
                {
                    this.val$value = iObservableValue;
                    this.val$binding = binding;
                    this.val$targetToModelStrategy = numericalTargetToModelUpdateStrategy;
                }

                public void handleValueChange(ValueChangeEvent event) {
                    Object newValue = event.diff.getNewValue();
                    DecimalFormat format = NumericalControl.this.setupFormat();
                    try {
                        Number number = format.parse((String)newValue);
                        this.val$value.setValue((Object)format.format(number));
                        this.val$binding.updateTargetToModel();
                    }
                    catch (ParseException parseException) {
                        this.val$targetToModelStrategy.revertToOldValue(this.val$value);
                    }
                }
            });
        }
        return binding;
    }

    private Class<?> getInstanceClass() {
        return this.getStructuralFeature().getEType().getInstanceClass();
    }

    private String getFormatText() {
        if (this.isInteger()) {
            return "The format is '#'.";
        }
        if (this.isDouble()) {
            return "The format is '#.#'.";
        }
        return "";
    }

    private boolean isDouble() {
        block9: {
            Class<?> instanceClass = this.getInstanceClass();
            if (instanceClass.isPrimitive()) {
                try {
                    return Double.class.getField("TYPE").get(null).equals(instanceClass) || Float.class.getField("TYPE").get(null).equals(instanceClass);
                }
                catch (IllegalArgumentException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (SecurityException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (IllegalAccessException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (NoSuchFieldException ex) {
                    Activator.logException(ex);
                    break block9;
                }
            }
            if (BigDecimal.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Double.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Float.class.isAssignableFrom(instanceClass)) {
                return true;
            }
        }
        return false;
    }

    private boolean isInteger() {
        block9: {
            Class<?> instanceClass = this.getInstanceClass();
            if (instanceClass.isPrimitive()) {
                try {
                    return Integer.class.getField("TYPE").get(null).equals(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass);
                }
                catch (IllegalArgumentException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (SecurityException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (IllegalAccessException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (NoSuchFieldException ex) {
                    Activator.logException(ex);
                    break block9;
                }
            }
            if (BigInteger.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Integer.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Long.class.isAssignableFrom(instanceClass)) {
                return true;
            }
        }
        return false;
    }

    private DecimalFormat setupFormat() {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getNumberInstance(this.getModelElementContext().getLocale());
        format.setParseIntegerOnly(this.isInteger());
        format.setParseBigDecimal(this.getInstanceClass().equals(BigDecimal.class) || this.getInstanceClass().equals(BigInteger.class));
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(100);
        return format;
    }

    private Number getDefaultValue() {
        Class<?> instanceClass = this.getInstanceClass();
        if (instanceClass.isPrimitive()) {
            try {
                if (Double.class.getField("TYPE").get(null).equals(instanceClass) || Float.class.getField("TYPE").get(null).equals(instanceClass) || Integer.class.getField("TYPE").get(null).equals(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass)) {
                    return 0;
                }
            }
            catch (IllegalArgumentException ex) {
                Activator.logException(ex);
            }
            catch (SecurityException ex) {
                Activator.logException(ex);
            }
            catch (IllegalAccessException ex) {
                Activator.logException(ex);
            }
            catch (NoSuchFieldException ex) {
                Activator.logException(ex);
            }
        } else {
            if (BigDecimal.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Double.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Float.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (BigInteger.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Integer.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Long.class.isAssignableFrom(instanceClass)) {
                return null;
            }
        }
        return null;
    }

    private class NumericalModelToTargetUpdateStrategy
    extends AbstractTextControl.ModelToTargetUpdateStrategy {
        private NumericalModelToTargetUpdateStrategy() {
            super(NumericalControl.this);
        }

        public Object convertValue(Object value) {
            DecimalFormat format = NumericalControl.this.setupFormat();
            return format.format(value);
        }
    }

    private class NumericalTargetToModelUpdateStrategy
    extends AbstractTextControl.TargetToModelUpdateStrategy {
        private DecimalFormat format;

        NumericalTargetToModelUpdateStrategy() {
            super(NumericalControl.this);
            this.format = NumericalControl.this.setupFormat();
        }

        protected Object convertValue(Object value) {
            String formatedNumber;
            block18: {
                try {
                    Number number = null;
                    if (value == null) {
                        number = NumericalControl.this.getDefaultValue();
                    } else {
                        ParsePosition pp = new ParsePosition(0);
                        number = this.format.parse((String)value, pp);
                        if (pp.getErrorIndex() != -1 || pp.getIndex() != ((String)value).length()) {
                            return this.revertToOldValue(value);
                        }
                        if (NumericalControl.this.isInteger()) {
                            boolean maxValue = false;
                            Class instanceClass = NumericalControl.this.getInstanceClass();
                            String formatedValue = "";
                            try {
                                if (Integer.class.isAssignableFrom(instanceClass) || Integer.class.getField("TYPE").get(null).equals(instanceClass)) {
                                    if (Integer.MAX_VALUE == number.intValue()) {
                                        maxValue = true;
                                        formatedValue = this.format.format(Integer.MAX_VALUE);
                                    }
                                } else if ((Long.class.isAssignableFrom(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass)) && Long.MAX_VALUE == number.longValue()) {
                                    maxValue = true;
                                    formatedValue = this.format.format(Long.MAX_VALUE);
                                }
                            }
                            catch (IllegalArgumentException ex) {
                                Activator.logException(ex);
                            }
                            catch (SecurityException ex) {
                                Activator.logException(ex);
                            }
                            catch (IllegalAccessException ex) {
                                Activator.logException(ex);
                            }
                            catch (NoSuchFieldException ex) {
                                Activator.logException(ex);
                            }
                            if (maxValue) {
                                NumericalControl.this.getText().setText(formatedValue);
                                return this.numberToInstanceClass(number);
                            }
                        }
                    }
                    formatedNumber = "";
                    if (number != null) {
                        formatedNumber = this.format.format(number);
                    }
                    NumericalControl.this.getText().setText(formatedNumber);
                    if (formatedNumber.length() != 0) break block18;
                    return null;
                }
                catch (ParseException parseException) {
                    return this.revertToOldValue(value);
                }
            }
            return this.numberToInstanceClass(this.format.parse(formatedNumber));
        }

        private Object numberToInstanceClass(Number number) {
            Class instanceClass = NumericalControl.this.getInstanceClass();
            if (instanceClass.isPrimitive()) {
                try {
                    if (Double.class.getField("TYPE").get(null).equals(instanceClass)) {
                        return number.doubleValue();
                    }
                    if (Integer.class.getField("TYPE").get(null).equals(instanceClass)) {
                        return number.intValue();
                    }
                    if (Long.class.getField("TYPE").get(null).equals(instanceClass)) {
                        return number.longValue();
                    }
                    if (Float.class.getField("TYPE").get(null).equals(instanceClass)) {
                        return Float.valueOf(number.floatValue());
                    }
                }
                catch (IllegalArgumentException ex) {
                    Activator.logException(ex);
                }
                catch (SecurityException ex) {
                    Activator.logException(ex);
                }
                catch (IllegalAccessException ex) {
                    Activator.logException(ex);
                }
                catch (NoSuchFieldException ex) {
                    Activator.logException(ex);
                }
            } else {
                if (BigDecimal.class.isAssignableFrom(instanceClass)) {
                    return number;
                }
                if (Double.class.isAssignableFrom(instanceClass)) {
                    return number.doubleValue();
                }
                if (BigInteger.class.isAssignableFrom(instanceClass)) {
                    return ((BigDecimal)number).toBigInteger();
                }
                if (Integer.class.isAssignableFrom(instanceClass)) {
                    return number.intValue();
                }
                if (Long.class.isAssignableFrom(instanceClass)) {
                    return number.longValue();
                }
                if (Float.class.isAssignableFrom(instanceClass)) {
                    return Float.valueOf(number.floatValue());
                }
            }
            return number;
        }

        private Object revertToOldValue(Object value) {
            if (NumericalControl.this.getStructuralFeature().getDefaultValue() == null && (value == null || value.equals(""))) {
                return null;
            }
            Object result = NumericalControl.this.getModelValue().getValue();
            MessageDialog messageDialog = new MessageDialog(NumericalControl.this.getText().getShell(), "Invalid Number", null, "The Number you have entered is invalid. The value will be unset.", 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
            new ECPDialogExecutor((Dialog)messageDialog){

                public void handleResult(int codeResult) {
                }
            }.execute();
            if (result == null) {
                NumericalControl.this.getText().setText("");
            } else {
                NumericalControl.this.getText().setText(this.format.format(result));
            }
            if (NumericalControl.this.getStructuralFeature().isUnsettable() && result == null) {
                NumericalControl.this.showUnsetLabel();
                return SetCommand.UNSET_VALUE;
            }
            return result;
        }
    }
}

