/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.table;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPCellEditor;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;

public class XmlDateCellEditor
extends CellEditor
implements ECPCellEditor {
    private DateTime dateWidget;
    private DateFormat dateFormat = SimpleDateFormat.getDateInstance(2);

    public XmlDateCellEditor() {
    }

    public XmlDateCellEditor(Composite parent) {
        super(parent);
    }

    public XmlDateCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    public IValueProperty getValueProperty() {
        return new WidgetValueProperty(){

            public Object getValueType() {
                return XMLGregorianCalendar.class;
            }

            protected Object doGetValue(Object source) {
                return XmlDateCellEditor.this.doGetValue();
            }

            protected void doSetValue(Object source, Object value) {
                XmlDateCellEditor.this.doSetValue(value);
            }

            public IObservableValue observe(Object source) {
                if (source instanceof XmlDateCellEditor) {
                    return this.observe((Widget)XmlDateCellEditor.this.dateWidget);
                }
                return super.observe(source);
            }
        };
    }

    public void instantiate(IItemPropertyDescriptor descriptor) {
    }

    protected Control createControl(Composite parent) {
        this.dateWidget = new DateTime(parent, 36);
        this.dateWidget.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_xmlDate");
        this.dateWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                XmlDateCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.dateWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                XmlDateCellEditor.this.applyEditorValueAndDeactivate();
            }
        });
        this.dateWidget.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.dateWidget.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                XmlDateCellEditor.this.focusLost();
            }
        });
        return this.dateWidget;
    }

    protected Object doGetValue() {
        Calendar selectedCalendarDate = Calendar.getInstance();
        selectedCalendarDate.set(1, this.dateWidget.getYear());
        selectedCalendarDate.set(2, this.dateWidget.getMonth());
        selectedCalendarDate.set(5, this.dateWidget.getDay());
        return new XMLCalendar(selectedCalendarDate.getTime(), 2);
    }

    protected void doSetFocus() {
        this.dateWidget.setFocus();
    }

    protected void doSetValue(Object value) {
        XMLGregorianCalendar cal = (XMLGregorianCalendar)value;
        GregorianCalendar gregCal = cal.toGregorianCalendar();
        this.dateWidget.setDate(gregCal.get(1), gregCal.get(2), gregCal.get(5));
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        super.keyReleaseOccured(keyEvent);
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }

    void applyEditorValueAndDeactivate() {
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            MessageFormat.format(this.getErrorMessage(), newValue);
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public String getFormatedString(Object value) {
        XMLGregorianCalendar cal = (XMLGregorianCalendar)value;
        if (value == null) {
            return "";
        }
        return this.dateFormat.format(cal.toGregorianCalendar().getTime());
    }

    public int getColumnWidthWeight() {
        return 75;
    }
}

