/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.util;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.util.ECPApplicableTester;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ECPStaticApplicableTester
implements ECPApplicableTester {
    private final boolean singleValue;
    private final int priority;
    private final Class<?> supportedClassType;
    private final Class<? extends EObject> supportedEObject;
    private final String supportedFeature;

    public ECPStaticApplicableTester(boolean singleValue, int priority, Class<?> supportedClassType, Class<? extends EObject> supportedEObject, String supportedFeature) {
        this.singleValue = singleValue;
        this.priority = priority;
        this.supportedClassType = supportedClassType;
        this.supportedEObject = supportedEObject;
        this.supportedFeature = supportedFeature;
    }

    @Override
    public int isApplicable(IItemPropertyDescriptor itemPropertyDescriptor, EObject eObject) {
        EStructuralFeature feature;
        block16: {
            if (this.isSingleValue() == itemPropertyDescriptor.isMany((Object)eObject)) {
                return -1;
            }
            feature = (EStructuralFeature)itemPropertyDescriptor.getFeature((Object)eObject);
            if (EAttribute.class.isInstance(feature)) {
                Class instanceClass = ((EAttribute)feature).getEAttributeType().getInstanceClass();
                if (instanceClass == null) {
                    return -1;
                }
                if (instanceClass.isPrimitive()) {
                    try {
                        Class primitive = (Class)this.getSupportedClassType().getField("TYPE").get(null);
                        if (!primitive.equals(instanceClass)) {
                            return -1;
                        }
                        break block16;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return -1;
                    }
                    catch (SecurityException securityException) {
                        return -1;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        return -1;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        return -1;
                    }
                }
                if (!this.getSupportedClassType().isAssignableFrom(instanceClass)) {
                    return -1;
                }
            } else if (EReference.class.isInstance(feature)) {
                Class<EObject> instanceClass = feature.getEType().getInstanceClass();
                if (instanceClass == null) {
                    instanceClass = EObject.class;
                }
                if (!this.getSupportedClassType().isAssignableFrom(instanceClass)) {
                    return -1;
                }
            }
        }
        if (this.getSupportedEObject().isInstance(eObject) && (this.getSupportedFeature() == null || feature.equals(eObject.eClass().getEStructuralFeature(this.getSupportedFeature())))) {
            return this.getPriority();
        }
        return -1;
    }

    public boolean isSingleValue() {
        return this.singleValue;
    }

    public int getPriority() {
        return this.priority;
    }

    public Class<? extends EObject> getSupportedEObject() {
        return this.supportedEObject;
    }

    public String getSupportedFeature() {
        return this.supportedFeature;
    }

    public Class<?> getSupportedClassType() {
        return this.supportedClassType;
    }
}

