/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.dialogs;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.explorereditorbridge.internal.Activator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelelementSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "STANDARD_DIALOG_SETTING";
    private static final String DIALOG_MESSAGE = "";
    private static final String DIALOG_TITLE = "";
    private static final String DIALOG_INITIAL_PATTERN = "**";
    private ILabelProvider labelProvider;
    private Collection<EObject> modelElements;
    protected ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
    protected AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);

    public ModelelementSelectionDialog(Shell shell) {
        this(false, shell);
    }

    public ModelelementSelectionDialog(Collection<EObject> modelElements, Shell shell) {
        this(modelElements, false, shell);
    }

    public ModelelementSelectionDialog(boolean multiSelection, Shell shell) {
        this(null, multiSelection, shell);
    }

    public ModelelementSelectionDialog(Collection<EObject> modelElements, boolean multiSelection, Shell shell) {
        super(shell, multiSelection);
        if (modelElements != null) {
            this.modelElements = modelElements;
        }
        this.setLabelProvider((ILabelProvider)this.adapterFactoryLabelProvider);
        this.setListLabelProvider(this.getLabelProvider());
        this.setDetailsLabelProvider(this.getLabelProvider());
        this.setBlockOnOpen(true);
        this.setTitle("");
        this.setMessage("");
        this.setInitialPattern(DIALOG_INITIAL_PATTERN);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public Collection<EObject> getModelElements() {
        return this.modelElements;
    }

    public void setModelElements(Collection<EObject> modelElements) {
        this.modelElements = modelElements;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ModelElementFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) {
        for (EObject modelElement : this.modelElements) {
            contentProvider.add((Object)modelElement, itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof EObject) {
            return this.getLabelProvider().getText(item);
        }
        return item.toString();
    }

    protected Comparator<EObject> getItemsComparator() {
        return new Comparator<EObject>(){

            @Override
            public int compare(EObject arg0, EObject arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    public boolean close() {
        this.composedAdapterFactory.dispose();
        this.adapterFactoryLabelProvider.dispose();
        return super.close();
    }

    public class ModelElementFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public ModelElementFilter() {
            super((FilteredItemsSelectionDialog)ModelelementSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            String label = ModelelementSelectionDialog.this.getLabelProvider().getText(item);
            if (!this.patternMatcher.getPattern().startsWith("*")) {
                this.patternMatcher.setPattern("*" + this.patternMatcher.getPattern() + "*");
            }
            return this.matches(label);
        }
    }
}

