/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.ECPControlContext;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.controls.AbstractTextControl;
import org.eclipse.emf.ecp.edit.internal.swt.controls.NumericalHelper;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericalControl
extends AbstractTextControl {
    public NumericalControl(boolean showLabel, IItemPropertyDescriptor itemPropertyDescriptor, EStructuralFeature feature, ECPControlContext modelElementContext, boolean embedded) {
        super(showLabel, itemPropertyDescriptor, feature, modelElementContext, embedded);
    }

    @Override
    protected int getTextWidgetStyle() {
        return super.getTextWidgetStyle() | 0x20000;
    }

    @Override
    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_numerical";
    }

    @Override
    protected String getUnsetLabelText() {
        return "No number set! Click to set number.";
    }

    @Override
    protected String getUnsetButtonTooltip() {
        return "Unset number";
    }

    @Override
    protected void customizeText(Text text) {
        super.customizeText(text);
        text.setMessage(this.getFormatText());
    }

    @Override
    public Binding bindValue() {
        ISWTObservableValue value = SWTObservables.observeText((Control)this.getText(), (int)16);
        NumericalTargetToModelUpdateStrategy targetToModelStrategy = new NumericalTargetToModelUpdateStrategy();
        NumericalModelToTargetUpdateStrategy modelToTargetStrategy = new NumericalModelToTargetUpdateStrategy();
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), (UpdateValueStrategy)targetToModelStrategy, (UpdateValueStrategy)modelToTargetStrategy);
        if (this.isEmbedded()) {
            value.addValueChangeListener(new IValueChangeListener((IObservableValue)value, binding, targetToModelStrategy){
                private final /* synthetic */ IObservableValue val$value;
                private final /* synthetic */ Binding val$binding;
                private final /* synthetic */ NumericalTargetToModelUpdateStrategy val$targetToModelStrategy;
                {
                    this.val$value = iObservableValue;
                    this.val$binding = binding;
                    this.val$targetToModelStrategy = numericalTargetToModelUpdateStrategy;
                }

                public void handleValueChange(ValueChangeEvent event) {
                    Object newValue = event.diff.getNewValue();
                    DecimalFormat format = NumericalHelper.setupFormat(NumericalControl.this.getModelElementContext().getLocale(), NumericalControl.this.getInstanceClass());
                    try {
                        Number number = format.parse((String)newValue);
                        this.val$value.setValue((Object)format.format(number));
                        this.val$binding.updateTargetToModel();
                    }
                    catch (ParseException parseException) {
                        this.val$targetToModelStrategy.revertToOldValue(this.val$value);
                    }
                }
            });
        }
        return binding;
    }

    private Class<?> getInstanceClass() {
        return this.getStructuralFeature().getEType().getInstanceClass();
    }

    private String getFormatText() {
        if (NumericalHelper.isInteger(this.getInstanceClass())) {
            return "The format is '#'.";
        }
        if (NumericalHelper.isDouble(this.getInstanceClass())) {
            return "The format is '#.#'.";
        }
        return "";
    }

    private class NumericalModelToTargetUpdateStrategy
    extends AbstractTextControl.ModelToTargetUpdateStrategy {
        private NumericalModelToTargetUpdateStrategy() {
            super(NumericalControl.this);
        }

        public Object convertValue(Object value) {
            DecimalFormat format = NumericalHelper.setupFormat(NumericalControl.this.getModelElementContext().getLocale(), NumericalControl.this.getInstanceClass());
            return format.format(value);
        }
    }

    private class NumericalTargetToModelUpdateStrategy
    extends AbstractTextControl.TargetToModelUpdateStrategy {
        private DecimalFormat format;

        NumericalTargetToModelUpdateStrategy() {
            super(NumericalControl.this);
            this.format = NumericalHelper.setupFormat(NumericalControl.this.getModelElementContext().getLocale(), NumericalControl.this.getInstanceClass());
        }

        protected Object convertValue(Object value) {
            String formatedNumber;
            block18: {
                try {
                    Number number = null;
                    if (value == null) {
                        number = NumericalHelper.getDefaultValue(NumericalControl.this.getInstanceClass());
                    } else {
                        ParsePosition pp = new ParsePosition(0);
                        number = this.format.parse((String)value, pp);
                        if (pp.getErrorIndex() != -1 || pp.getIndex() != ((String)value).length()) {
                            return this.revertToOldValue(value);
                        }
                        if (NumericalHelper.isInteger(NumericalControl.this.getInstanceClass())) {
                            boolean maxValue = false;
                            Class instanceClass = NumericalControl.this.getInstanceClass();
                            String formatedValue = "";
                            try {
                                if (Integer.class.isAssignableFrom(instanceClass) || Integer.class.getField("TYPE").get(null).equals(instanceClass)) {
                                    if (Integer.MAX_VALUE == number.intValue()) {
                                        maxValue = true;
                                        formatedValue = this.format.format(Integer.MAX_VALUE);
                                    }
                                } else if ((Long.class.isAssignableFrom(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass)) && Long.MAX_VALUE == number.longValue()) {
                                    maxValue = true;
                                    formatedValue = this.format.format(Long.MAX_VALUE);
                                }
                            }
                            catch (IllegalArgumentException ex) {
                                Activator.logException(ex);
                            }
                            catch (SecurityException ex) {
                                Activator.logException(ex);
                            }
                            catch (IllegalAccessException ex) {
                                Activator.logException(ex);
                            }
                            catch (NoSuchFieldException ex) {
                                Activator.logException(ex);
                            }
                            if (maxValue) {
                                NumericalControl.this.getText().setText(formatedValue);
                                return NumericalHelper.numberToInstanceClass(number, NumericalControl.this.getInstanceClass());
                            }
                        }
                    }
                    formatedNumber = "";
                    if (number != null) {
                        formatedNumber = this.format.format(number);
                    }
                    NumericalControl.this.getText().setText(formatedNumber);
                    if (formatedNumber.length() != 0) break block18;
                    return null;
                }
                catch (ParseException parseException) {
                    return this.revertToOldValue(value);
                }
            }
            return NumericalHelper.numberToInstanceClass(this.format.parse(formatedNumber), NumericalControl.this.getInstanceClass());
        }

        private Object revertToOldValue(Object value) {
            if (NumericalControl.this.getStructuralFeature().getDefaultValue() == null && (value == null || value.equals(""))) {
                return null;
            }
            Object result = NumericalControl.this.getModelValue().getValue();
            MessageDialog messageDialog = new MessageDialog(NumericalControl.this.getText().getShell(), "Invalid Number", null, "The Number you have entered is invalid. The value will be unset.", 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
            new ECPDialogExecutor((Dialog)messageDialog){

                public void handleResult(int codeResult) {
                }
            }.execute();
            if (result == null) {
                NumericalControl.this.getText().setText("");
            } else {
                NumericalControl.this.getText().setText(this.format.format(result));
            }
            if (NumericalControl.this.getStructuralFeature().isUnsettable() && result == null) {
                NumericalControl.this.showUnsetLabel();
                return SetCommand.UNSET_VALUE;
            }
            return result;
        }
    }
}

