/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.internal.e3;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.edit.ECPControlContext;
import org.eclipse.emf.ecp.editor.EditorFactory;
import org.eclipse.emf.ecp.editor.IEditorCompositeProvider;
import org.eclipse.emf.ecp.editor.internal.e3.Activator;
import org.eclipse.emf.ecp.editor.internal.e3.ECPCommand;
import org.eclipse.emf.ecp.editor.internal.e3.MEEditor;
import org.eclipse.emf.ecp.editor.internal.e3.ShortLabelProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.menus.IMenuService;

public class MEEditorPage
extends FormPage {
    private ScrolledForm form;
    private final ECPControlContext modelElementContext;
    private IEditorCompositeProvider editorPageContent;
    private ShortLabelProvider shortLabelProvider;
    private ComposedAdapterFactory composedAdapterFactory;

    public MEEditorPage(MEEditor editor, String id, String title, ECPControlContext modelElementContext, EObject modelElement) {
        super((FormEditor)editor, id, title);
        this.modelElementContext = modelElementContext;
    }

    public MEEditorPage(MEEditor editor, String id, String title, ECPControlContext modelElementContext, EObject modelElement, EStructuralFeature problemFeature) {
        this(editor, id, title, modelElementContext, modelElement);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.shortLabelProvider = new ShortLabelProvider((AdapterFactory)this.composedAdapterFactory);
        FormToolkit toolkit = this.getEditor().getToolkit();
        this.form = managedForm.getForm();
        this.form.setShowFocusedControl(true);
        toolkit.decorateFormHeading(this.form.getForm());
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.editorPageContent = EditorFactory.INSTANCE.getEditorComposite(this.modelElementContext);
        this.editorPageContent.createUI(body);
        this.form.setImage(this.shortLabelProvider.getImage(this.modelElementContext.getModelElement()));
        this.createToolbar();
        this.form.pack();
        this.updateSectionTitle();
    }

    public void updateSectionTitle() {
        String name = this.shortLabelProvider.getText(this.modelElementContext.getModelElement());
        name = String.valueOf(name) + " [" + this.modelElementContext.getModelElement().eClass().getName() + "]";
        try {
            this.form.setText(name);
        }
        catch (SWTException sWTException) {}
    }

    private void createToolbar() {
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        this.form.getToolBarManager().add((IAction)new Action("", Activator.getImageDescriptor("IMG_TOOL_DELETE")){

            public void run() {
                new ECPCommand(MEEditorPage.this.modelElementContext.getModelElement(), MEEditorPage.this.modelElementContext.getEditingDomain()){

                    protected void doRun() {
                        EcoreUtil.delete((EObject)MEEditorPage.this.modelElementContext.getModelElement(), (boolean)true);
                    }
                }.run(true);
                MEEditorPage.this.getEditor().close(true);
            }
        });
        menuService.populateContributionManager((ContributionManager)this.form.getToolBarManager(), "toolbar:org.eclipse.emf.ecp.editor.internal.e3.MEEditorPage");
        this.form.getToolBarManager().update(true);
    }

    public void setFocus() {
        this.editorPageContent.focus();
    }

    public void dispose() {
        this.editorPageContent.dispose();
        this.composedAdapterFactory.dispose();
        this.shortLabelProvider.dispose();
        this.form.dispose();
        super.dispose();
    }

    static /* synthetic */ ECPControlContext access$0(MEEditorPage mEEditorPage) {
        return mEEditorPage.modelElementContext;
    }
}

