/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.validation.connector;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectContentChangedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectsChangedObserver;
import org.eclipse.emf.ecp.validation.api.IValidationService;
import org.eclipse.emf.ecp.validation.api.IValidationServiceProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.ecp.validation.connector";
    private static Activator plugin;
    private IValidationServiceProvider validationServiceProvider;
    private ValidationObserver validationObserver;
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;
        plugin = this;
        this.validationObserver = new ValidationObserver();
        ECPUtil.getECPObserverBus().register((ECPObserver)this.validationObserver);
    }

    public void stop(BundleContext context) throws Exception {
        ECPUtil.getECPObserverBus().unregister((ECPObserver)this.validationObserver);
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public IValidationService getValidationService(ECPProject project) {
        return this.getValidationServiceProvider().getValidationService((Object)project);
    }

    private IValidationServiceProvider getValidationServiceProvider() {
        if (this.validationServiceProvider == null) {
            ServiceReference reference = this.context.getServiceReference(IValidationServiceProvider.class);
            this.validationServiceProvider = (IValidationServiceProvider)this.context.getService(reference);
        }
        return this.validationServiceProvider;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource(path));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValidationObserver
    implements ECPProjectsChangedObserver,
    ECPProjectContentChangedObserver {
        private ValidationObserver() {
        }

        public void projectsChanged(Collection<ECPProject> oldProjects, Collection<ECPProject> newProjects) {
            for (ECPProject project : oldProjects) {
                if (newProjects.contains(project)) continue;
                Activator.this.getValidationServiceProvider().deleteValidationService((Object)project);
            }
        }

        public Collection<Object> objectsChanged(ECPProject project, Collection<Object> objects) {
            HashSet<Object> allAffectedElements = new HashSet<Object>();
            for (Object object : objects) {
                if (!(object instanceof EObject)) continue;
                EObject eObject = (EObject)object;
                if (eObject.eContainer() == null && eObject.eResource() == null) {
                    for (EObject childObject : eObject.eContents()) {
                        Activator.this.getValidationService(project).remove(childObject);
                    }
                    Activator.this.getValidationService(project).remove(eObject);
                    continue;
                }
                Set affected = Activator.this.getValidationService(project).validate(eObject);
                allAffectedElements.addAll(affected);
            }
            return allAffectedElements;
        }
    }
}

