/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.composites;

import org.eclipse.emf.ecp.core.util.ECPCheckoutSource;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.spi.ui.UIProvider;
import org.eclipse.emf.ecp.spi.ui.UIProviderRegistry;
import org.eclipse.emf.ecp.ui.common.CheckoutProjectComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CheckoutProjectCompositeImpl
implements CheckoutProjectComposite {
    private CheckoutProjectComposite.CheckoutProjectChangeListener listener;
    private String projectName;
    private ECPProperties projectProperties = ECPUtil.createProperties();
    private final ECPCheckoutSource checkoutSource;
    private final UIProvider uiProvider;

    public CheckoutProjectCompositeImpl(ECPCheckoutSource checkoutSource) {
        this.checkoutSource = checkoutSource;
        this.projectName = this.checkoutSource.getDefaultCheckoutName();
        if (this.projectName == null) {
            this.projectName = "";
        }
        this.uiProvider = UIProviderRegistry.INSTANCE.getUIProvider(checkoutSource);
    }

    public Composite createUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setText(Messages.CheckoutProjectComposite_ProjectName);
        final Text projectNameText = new Text(composite, 2048);
        projectNameText.setText(this.projectName);
        projectNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutProjectCompositeImpl.this.projectName = projectNameText.getText();
                if (CheckoutProjectCompositeImpl.this.listener != null) {
                    CheckoutProjectCompositeImpl.this.listener.projectNameChanged(CheckoutProjectCompositeImpl.this.projectName);
                }
            }
        });
        StackLayout providerStackLayout = new StackLayout();
        Composite providerStack = new Composite(composite, 0);
        providerStack.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        providerStack.setLayout((Layout)providerStackLayout);
        Control checkoutUI = this.uiProvider.createCheckoutUI(providerStack, this.checkoutSource, this.projectProperties);
        if (checkoutUI != null) {
            providerStackLayout.topControl = checkoutUI;
            providerStack.layout();
        }
        return composite;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ECPProperties getProjectProperties() {
        return this.projectProperties;
    }

    public ECPCheckoutSource getCheckoutSource() {
        return this.checkoutSource;
    }

    public UIProvider getUiProvider() {
        return this.uiProvider;
    }

    public void setListener(CheckoutProjectComposite.CheckoutProjectChangeListener listener) {
        this.listener = listener;
    }

    public void dispose() {
    }
}

