/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.decorator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.emfstore.internal.ui.decorator.EMFStoreDirtyDecoratorCachedTree;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.observers.OperationObserver;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFStoreDirtyObserver
implements OperationObserver {
    private ProjectSpace projectSpace;
    private InternalProject internalProject;
    private Map<ModelElementId, Integer> modelElementIdToOperationCount = new HashMap<ModelElementId, Integer>();
    private Set<EObject> lastAffected;
    private int operations;

    public EMFStoreDirtyObserver(ProjectSpace projectSpace, InternalProject project) {
        this.projectSpace = projectSpace;
        this.internalProject = project;
        if (!projectSpace.isShared()) {
            return;
        }
        this.initCachedTree(projectSpace);
    }

    private void initCachedTree(ProjectSpace ps) {
        for (AbstractOperation operation : ps.getOperations()) {
            ++this.operations;
            for (ModelElementId modelElementId : operation.getAllInvolvedModelElements()) {
                EObject element = ps.getProject().getModelElement(modelElementId);
                if (element == null) continue;
                EMFStoreDirtyDecoratorCachedTree.getInstance((ECPProject)this.internalProject).addOperation(element);
            }
            this.removeDeletedElementsFromCachedTree(ps, operation);
        }
    }

    public void operationExecuted(AbstractOperation operation) {
        ++this.operations;
        if (!this.projectSpace.isShared()) {
            return;
        }
        this.lastAffected = new HashSet<EObject>();
        for (ModelElementId modelElementId : operation.getAllInvolvedModelElements()) {
            Project project = this.projectSpace.getProject();
            EObject element = project.getModelElement(modelElementId);
            if (element != null) {
                this.lastAffected.add(element);
                this.lastAffected.addAll(EMFStoreDirtyDecoratorCachedTree.getInstance((ECPProject)this.internalProject).addOperation(element));
            }
            this.removeDeletedElementsFromCachedTree(this.projectSpace, operation);
        }
        this.updateDecoration();
    }

    public void operationUndone(AbstractOperation operation) {
        --this.operations;
        if (!this.projectSpace.isShared()) {
            return;
        }
        this.lastAffected = new HashSet<EObject>();
        for (ModelElementId modelElementId : operation.getAllInvolvedModelElements()) {
            Project project = this.projectSpace.getProject();
            EObject element = project.get((Object)modelElementId);
            if (element == null) continue;
            this.lastAffected.add(element);
            this.lastAffected.addAll(EMFStoreDirtyDecoratorCachedTree.getInstance((ECPProject)this.internalProject).removeOperation(element));
        }
        this.initializeRestoredDeletedElement(operation);
        this.updateDecoration();
    }

    private void updateDecoration() {
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        if (decoratorManager != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    decoratorManager.update("org.eclipse.emf.ecp.emfstore.ui.decorators.EMFStoreDirtyDecorator");
                }
            });
        }
    }

    private void removeDeletedElementsFromCachedTree(ProjectSpace projectSpace, AbstractOperation operation) {
        CreateDeleteOperation cdo;
        if (operation instanceof CreateDeleteOperation && (cdo = (CreateDeleteOperation)operation).isDelete()) {
            this.modelElementIdToOperationCount.put(cdo.getModelElementId(), EMFStoreDirtyDecoratorCachedTree.getInstance((ECPProject)this.internalProject).getOwnValue(projectSpace.getProject().get((Object)cdo.getModelElementId())));
            EMFStoreDirtyDecoratorCachedTree.getInstance((ECPProject)this.internalProject).remove(projectSpace.getProject().get((Object)cdo.getModelElementId()));
        }
    }

    private void initializeRestoredDeletedElement(AbstractOperation operation) {
        CreateDeleteOperation cdo;
        if (operation instanceof CreateDeleteOperation && (cdo = (CreateDeleteOperation)operation).isDelete()) {
            this.lastAffected.addAll(EMFStoreDirtyDecoratorCachedTree.getInstance((ECPProject)this.internalProject).setOperationCount(this.projectSpace.getProject().get((Object)cdo.getModelElementId()), this.modelElementIdToOperationCount.get(cdo.getModelElementId().toAPI())));
            this.modelElementIdToOperationCount.remove(this.projectSpace.getProject().get((Object)cdo.getModelElementId()));
        }
    }

    public Set<EObject> getLastAffected() {
        return this.lastAffected;
    }

    public void clearObserverCache() {
        this.modelElementIdToOperationCount.clear();
        this.operations = 0;
    }

    public boolean isDirty() {
        return this.operations > 0;
    }
}

