/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.properties;

import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ECPProjectProperties
extends Properties<ECPProject> {
    private static final IProperties<ECPProject> INSTANCE = new ECPProjectProperties();

    private ECPProjectProperties() {
        super(ECPProject.class);
        this.add((Property)new Property<ECPProject>("name", "Name", "The name of this project."){

            protected Object eval(ECPProject project) {
                return project.getName();
            }
        });
        this.add((Property)new Property<ECPProject>("repositoryName"){

            protected Object eval(ECPProject project) {
                return project.getRepository().getName();
            }
        });
        this.add((Property)new Property<ECPProject>("repositoryLabel", "Repository", "The repository of this project."){

            protected Object eval(ECPProject project) {
                return project.getRepository().getLabel();
            }
        });
        this.add((Property)new Property<ECPProject>("providerName"){

            protected Object eval(ECPProject project) {
                ECPProvider provider = project.getProvider();
                if (provider != null) {
                    return provider.getName();
                }
                return "<unknown provider>";
            }
        });
        this.add((Property)new Property<ECPProject>("providerLabel", "Provider", "The provider of this project."){

            protected Object eval(ECPProject project) {
                ECPProvider provider = project.getProvider();
                if (provider != null) {
                    return provider.getLabel();
                }
                return "<unknown provider>";
            }
        });
        this.add((Property)new Property<ECPProject>("isDirty", "Is project dirty", "Has this project unsaved changes?"){

            protected Object eval(ECPProject project) {
                return project.hasDirtyContents();
            }
        });
        this.add((Property)new Property<ECPProject>("open"){

            protected Object eval(ECPProject closeable) {
                return closeable.isOpen();
            }
        });
        this.add((Property)new Property<ECPProject>("closed"){

            protected Object eval(ECPProject closeable) {
                return !closeable.isOpen();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Tester
    extends DefaultPropertyTester<ECPProject> {
        private static final String NAMESPACE = "org.eclipse.emf.ecp.core.project";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

