/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecp.core.util.ECPElement;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.internal.core.util.ElementDescriptor;
import org.eclipse.emf.ecp.internal.core.util.Registry;
import org.eclipse.emf.ecp.spi.core.util.InternalElementRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementRegistry<ELEMENT extends ECPElement, OBSERVER extends ECPObserver>
extends Registry<ELEMENT, OBSERVER> {
    private final List<InternalElementRegistry.ResolveListener<ELEMENT>> resolveListeners = new ArrayList<InternalElementRegistry.ResolveListener<ELEMENT>>();

    public final synchronized void addResolveListener(InternalElementRegistry.ResolveListener<ELEMENT> listener) {
        this.resolveListeners.add(listener);
    }

    public final synchronized void removeResolveListener(InternalElementRegistry.ResolveListener<ELEMENT> listener) {
        this.resolveListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void descriptorChanged(ElementDescriptor<ELEMENT> descriptor, boolean resolved) {
        InternalElementRegistry.ResolveListener[] listeners;
        ElementRegistry elementRegistry = this;
        synchronized (elementRegistry) {
            listeners = this.resolveListeners.toArray(new InternalElementRegistry.ResolveListener[this.resolveListeners.size()]);
        }
        InternalElementRegistry.ResolveListener[] resolveListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            InternalElementRegistry.ResolveListener listener = resolveListenerArray[n2];
            try {
                listener.descriptorChanged(descriptor, resolved);
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
            ++n2;
        }
    }

    @Override
    protected String getElementName(ELEMENT element) {
        return element.getName();
    }
}

