/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.internal.core.util.ElementDescriptor;
import org.eclipse.emf.ecp.internal.core.util.ElementRegistry;
import org.eclipse.emf.ecp.spi.core.util.ECPDisposable;
import org.eclipse.emf.ecp.spi.core.util.InternalRegistryElement;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensionParser<ELEMENT extends InternalRegistryElement>
extends Lifecycle
implements IRegistryChangeListener {
    private final ElementRegistry<ELEMENT, ?> elementRegistry;
    private final String namespace;
    private final String name;

    public ExtensionParser(ElementRegistry<ELEMENT, ?> elementRegistry, String namespace, String name) {
        this.elementRegistry = elementRegistry;
        this.namespace = namespace;
        this.name = name;
    }

    public final ElementRegistry<ELEMENT, ?> getElementRegistry() {
        return this.elementRegistry;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final String getName() {
        return this.name;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        HashSet<String> remove = new HashSet<String>();
        HashSet add = new HashSet();
        IExtensionDelta[] iExtensionDeltaArray = event.getExtensionDeltas(this.namespace, this.name);
        int n = iExtensionDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionDelta delta = iExtensionDeltaArray[n2];
            IExtension extension = delta.getExtension();
            int kind = delta.getKind();
            switch (kind) {
                case 1: {
                    this.addExtension(extension, add);
                    break;
                }
                case 2: {
                    this.removeExtension(extension, remove);
                }
            }
            ++n2;
        }
        Set removedElements = this.elementRegistry.doChangeElements(remove, add);
        if (removedElements != null) {
            for (InternalRegistryElement removedElement : removedElements) {
                if (!(removedElement instanceof ECPDisposable)) continue;
                InternalRegistryElement disposable = removedElement;
                disposable.dispose();
            }
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        String extensionPointID = String.valueOf(this.namespace) + "." + this.name;
        HashSet add = new HashSet();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(extensionPointID);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.addExtension(extension, add);
            ++n2;
        }
        this.elementRegistry.doChangeElements(null, add);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this, this.namespace);
    }

    protected void doDeactivate() throws Exception {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        super.doDeactivate();
    }

    protected void addExtension(IExtension extension, Set<ELEMENT> result) {
        String name = extension.getUniqueIdentifier();
        IConfigurationElement configurationElement = extension.getConfigurationElements()[0];
        ELEMENT element = this.createElement(name, configurationElement);
        element.setLabel(extension.getLabel());
        element.setDescription(configurationElement.getAttribute("description"));
        result.add(element);
    }

    protected void removeExtension(IExtension extension, Set<String> result) {
        String name = extension.getUniqueIdentifier();
        result.add(name);
    }

    protected abstract ELEMENT createElement(String var1, IConfigurationElement var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtensionDescriptor<ELEMENT extends InternalRegistryElement>
    extends ElementDescriptor<ELEMENT> {
        private final String type;
        private final IConfigurationElement configurationElement;

        public ExtensionDescriptor(ElementRegistry<ELEMENT, ?> registry, String name, String type, IConfigurationElement configurationElement) {
            super(registry, name);
            this.type = type;
            this.configurationElement = configurationElement;
            try {
                String prefix;
                String bundleName = configurationElement.getContributor().getName();
                Bundle bundle = Platform.getBundle((String)bundleName);
                String location = bundle.getLocation();
                if (location.startsWith("initial@")) {
                    location = location.substring("initial@".length());
                }
                if (location.startsWith(prefix = "reference:file:")) {
                    location = location.substring(prefix.length());
                    System.out.println(String.valueOf(this.getClass().getSimpleName()) + ": " + bundleName + " [" + bundle.getBundleId() + "] --> file:" + new File(location).getCanonicalPath());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public String getType() {
            return this.type;
        }

        public final IConfigurationElement getConfigurationElement() {
            return this.configurationElement;
        }

        @Override
        protected ELEMENT resolve() throws Exception {
            return (ELEMENT)((InternalRegistryElement)this.configurationElement.createExecutableExtension(this.getClassAttributeName()));
        }

        protected String getClassAttributeName() {
            return "class";
        }
    }
}

