/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.ECPControlContext;
import org.eclipse.emf.ecp.edit.internal.swt.controls.SingleControl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractTextControl
extends SingleControl {
    private Text text;
    private boolean doVerify;
    private ControlDecoration controlDecoration;

    public AbstractTextControl(boolean showLabel, IItemPropertyDescriptor itemPropertyDescriptor, EStructuralFeature feature, ECPControlContext modelElementContext, boolean embedded) {
        super(showLabel, itemPropertyDescriptor, feature, modelElementContext, embedded);
    }

    protected void updateValidationColor(Color color) {
        this.text.setBackground(color);
    }

    protected void fillControlComposite(Composite composite) {
        this.doVerify = false;
        this.createTextWidget(composite);
        this.addControlDecoration(composite.getParent());
    }

    private void addControlDecoration(Composite composite) {
        this.controlDecoration = new ControlDecoration((Control)this.text, 16512, composite);
        this.controlDecoration.hide();
        this.controlDecoration.setDescriptionText("Invalid input");
        this.controlDecoration.setShowHover(true);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.controlDecoration.setImage(fieldDecoration.getImage());
    }

    private void createTextWidget(Composite composite) {
        this.text = new Text(composite, this.getTextWidgetStyle());
        this.text.setLayoutData((Object)this.getTextWidgetLayoutData());
        if (this.getStructuralFeature().isUnsettable()) {
            this.text.setMessage("<unset>");
        }
        this.text.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getTextVariantID());
        this.customizeText(this.text);
    }

    protected void customizeText(Text text) {
    }

    protected abstract String getTextVariantID();

    protected GridData getTextWidgetLayoutData() {
        return new GridData(4, 4, true, true);
    }

    protected int getTextWidgetStyle() {
        return 2052;
    }

    protected Control[] getControlsForTooltip() {
        return new Control[]{this.text};
    }

    public void setEditable(boolean isEditable) {
        this.text.setEditable(isEditable);
    }

    public Binding bindValue() {
        ISWTObservableValue value = SWTObservables.observeText((Control)this.text, (int)16);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), (UpdateValueStrategy)new TargetToModelUpdateStrategy(), (UpdateValueStrategy)new ModelToTargetUpdateStrategy());
        return binding;
    }

    protected void setUnvalidatedString(String string) {
        boolean oldDoVerify = this.doVerify;
        this.doVerify = false;
        this.text.setText(string);
        this.doVerify = oldDoVerify;
    }

    public void dispose() {
        this.controlDecoration.dispose();
        this.text.dispose();
        super.dispose();
    }

    public Text getText() {
        return this.text;
    }

    class EMFUpdateConvertValueStrategy
    extends EMFUpdateValueStrategy {
        public Object convert(Object value) {
            return this.convertValue(value);
        }

        protected Object convertValue(Object value) {
            return super.convert(value);
        }
    }

    protected class ModelToTargetUpdateStrategy
    extends EMFUpdateConvertValueStrategy {
        protected ModelToTargetUpdateStrategy() {
        }

        public Object convert(Object value) {
            AbstractTextControl.this.controlDecoration.hide();
            AbstractTextControl.this.updateValidationColor(null);
            return this.convertValue(value);
        }
    }

    protected class TargetToModelUpdateStrategy
    extends EMFUpdateConvertValueStrategy {
        protected TargetToModelUpdateStrategy() {
        }

        public IStatus validateAfterGet(Object value) {
            IStatus status = super.validateAfterGet(value);
            if (status.getSeverity() == 4) {
                AbstractTextControl.this.controlDecoration.show();
                AbstractTextControl.this.controlDecoration.setDescriptionText(status.getMessage());
            } else {
                AbstractTextControl.this.controlDecoration.hide();
                AbstractTextControl.this.controlDecoration.setDescriptionText(null);
            }
            return status;
        }

        public Object convert(Object value) {
            try {
                AbstractTextControl.this.controlDecoration.hide();
                AbstractTextControl.this.updateValidationColor(null);
                if ("".equals(value)) {
                    value = null;
                }
                if (value == null && AbstractTextControl.this.getStructuralFeature().isUnsettable()) {
                    return SetCommand.UNSET_VALUE;
                }
                Object convertedValue = this.convertValue(value);
                return convertedValue;
            }
            catch (IllegalArgumentException e) {
                AbstractTextControl.this.controlDecoration.show();
                AbstractTextControl.this.updateValidationColor(AbstractTextControl.this.getText().getShell().getDisplay().getSystemColor(3));
                AbstractTextControl.this.controlDecoration.setDescriptionText("Invalid input " + e.getLocalizedMessage());
                throw e;
            }
        }
    }
}

