/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.DateAndTimeObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.ECPControlContext;
import org.eclipse.emf.ecp.edit.internal.swt.controls.SingleControl;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;

public class DateTimeControl
extends SingleControl {
    private DateTime dateWidget;
    private DateTime timeWidget;

    public DateTimeControl(boolean showLabel, IItemPropertyDescriptor itemPropertyDescriptor, EStructuralFeature feature, ECPControlContext modelElementContext, boolean embedded) {
        super(showLabel, itemPropertyDescriptor, feature, modelElementContext, embedded);
    }

    protected void fillControlComposite(Composite dateTimeComposite) {
        GridLayoutFactory.fillDefaults().spacing(2, 0).numColumns(4).applyTo(dateTimeComposite);
        this.createDateAndTimeWidget(dateTimeComposite);
    }

    private void createDateAndTimeWidget(Composite composite) {
        int numColumns = 3;
        if (this.isEmbedded()) {
            numColumns = 2;
        }
        GridLayoutFactory.fillDefaults().numColumns(numColumns).spacing(2, 0).equalWidth(false).applyTo(composite);
        this.dateWidget = new DateTime(composite, 2080);
        this.dateWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dateWidget.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_date");
        this.timeWidget = new DateTime(composite, 34944);
        this.timeWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        this.timeWidget.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_time");
    }

    public void setEditable(boolean isEditable) {
        this.dateWidget.setEnabled(isEditable);
        this.timeWidget.setEnabled(isEditable);
    }

    public Binding bindValue() {
        ISWTObservableValue dateObserver = SWTObservables.observeSelection((Control)this.dateWidget);
        ISWTObservableValue timeObserver = SWTObservables.observeSelection((Control)this.timeWidget);
        DateAndTimeObservableValue target = new DateAndTimeObservableValue((IObservableValue)dateObserver, (IObservableValue)timeObserver);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)target, this.getModelValue());
        return binding;
    }

    protected String getUnsetLabelText() {
        return "No date set! Click to set date.";
    }

    protected String getUnsetButtonTooltip() {
        return "Unset Date";
    }

    protected Control[] getControlsForTooltip() {
        return new Control[]{this.dateWidget, this.timeWidget};
    }
}

